/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertPath
extends CertPath {
    private static final long serialVersionUID = 4989800333263052980L;
    private List certs;
    private static final String COUNT_ENCODING = "count";
    private static final String PKCS7_ENCODING = "PKCS7";
    private static final String PKIPATH_ENCODING = "PkiPath";
    private static final Collection<String> encodingList;

    public X509CertPath(List list) throws CertificateException {
        super("X.509");
        this.certs = Collections.unmodifiableList(new ArrayList(list));
        for (Object e : this.certs) {
            if (e instanceof X509Certificate) continue;
            throw new CertificateException("List is not all X509Certificates: " + e.getClass().getName());
        }
    }

    public X509CertPath(InputStream inputStream) throws CertificateException {
        this(inputStream, PKIPATH_ENCODING);
    }

    public X509CertPath(InputStream inputStream, String string) throws CertificateException {
        super("X.509");
        if (PKIPATH_ENCODING.equals(string)) {
            this.certs = X509CertPath.parsePKIPATH(inputStream);
        } else if (PKCS7_ENCODING.equals(string)) {
            this.certs = X509CertPath.parsePKCS7(inputStream);
        } else {
            throw new CertificateException("unsupported encoding");
        }
    }

    private static List parsePKIPATH(InputStream inputStream) throws CertificateException {
        ArrayList<Certificate> arrayList = null;
        CertificateFactory certificateFactory = null;
        if (inputStream == null) {
            throw new CertificateException("input stream is null");
        }
        try {
            DerInputStream derInputStream = new DerInputStream(X509CertPath.readAllBytes(inputStream));
            DerValue[] derValueArray = derInputStream.getSequence(3);
            if (derValueArray.length == 0) {
                return Collections.EMPTY_LIST;
            }
            certificateFactory = CertificateFactory.getInstance("X.509");
            arrayList = new ArrayList<Certificate>(derValueArray.length);
            for (int i = derValueArray.length - 1; i >= 0; --i) {
                arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(derValueArray[i].toByteArray())));
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (IOException iOException) {
            CertificateException certificateException = new CertificateException("IOException parsing PkiPath data: " + iOException);
            certificateException.initCause(iOException);
            throw certificateException;
        }
    }

    private static List parsePKCS7(InputStream inputStream) throws CertificateException {
        List<X509Certificate> list;
        if (inputStream == null) {
            throw new CertificateException("input stream is null");
        }
        try {
            PKCS7 pKCS7;
            X509Certificate[] x509CertificateArray;
            if (!inputStream.markSupported()) {
                inputStream = new ByteArrayInputStream(X509CertPath.readAllBytes(inputStream));
            }
            list = (x509CertificateArray = (pKCS7 = new PKCS7(inputStream)).getCertificates()) != null ? Arrays.asList(x509CertificateArray) : new ArrayList<X509Certificate>(0);
        }
        catch (IOException iOException) {
            throw new CertificateException("IOException parsing PKCS7 data: " + iOException);
        }
        return Collections.unmodifiableList(list);
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encodePKIPATH();
    }

    private byte[] encodePKIPATH() throws CertificateEncodingException {
        ListIterator listIterator = this.certs.listIterator(this.certs.size());
        try {
            Object object;
            DerOutputStream derOutputStream = new DerOutputStream();
            while (listIterator.hasPrevious()) {
                object = (X509Certificate)listIterator.previous();
                if (this.certs.lastIndexOf(object) != this.certs.indexOf(object)) {
                    throw new CertificateEncodingException("Duplicate Certificate");
                }
                byte[] byArray = ((Certificate)object).getEncoded();
                derOutputStream.write(byArray);
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).write((byte)48, derOutputStream);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            CertificateEncodingException certificateEncodingException = new CertificateEncodingException("IOException encoding PkiPath data: " + iOException);
            certificateEncodingException.initCause(iOException);
            throw certificateEncodingException;
        }
    }

    private byte[] encodePKCS7() throws CertificateEncodingException {
        PKCS7 pKCS7 = new PKCS7(new AlgorithmId[0], new ContentInfo(ContentInfo.DATA_OID, null), this.certs.toArray(new X509Certificate[this.certs.size()]), new SignerInfo[0]);
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            pKCS7.encodeSignedData(derOutputStream);
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.getMessage());
        }
        return derOutputStream.toByteArray();
    }

    @Override
    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (PKIPATH_ENCODING.equals(string)) {
            return this.encodePKIPATH();
        }
        if (PKCS7_ENCODING.equals(string)) {
            return this.encodePKCS7();
        }
        throw new CertificateEncodingException("unsupported encoding");
    }

    public static Iterator<String> getEncodingsStatic() {
        return encodingList.iterator();
    }

    @Override
    public Iterator<String> getEncodings() {
        return X509CertPath.getEncodingsStatic();
    }

    public List<X509Certificate> getCertificates() {
        return this.certs;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(PKIPATH_ENCODING);
        arrayList.add(PKCS7_ENCODING);
        encodingList = Collections.unmodifiableCollection(arrayList);
    }
}

