/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;

class SegmentCache {
    private static SegmentCache sharedCache = new SegmentCache();
    private List segments = new ArrayList(11);

    public static SegmentCache getSharedInstance() {
        return sharedCache;
    }

    public static Segment getSharedSegment() {
        return SegmentCache.getSharedInstance().getSegment();
    }

    public static void releaseSharedSegment(Segment segment) {
        SegmentCache.getSharedInstance().releaseSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment() {
        SegmentCache segmentCache = this;
        synchronized (segmentCache) {
            int n = this.segments.size();
            if (n > 0) {
                return (Segment)this.segments.remove(n - 1);
            }
        }
        return new CachedSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSegment(Segment segment) {
        if (segment instanceof CachedSegment) {
            SegmentCache segmentCache = this;
            synchronized (segmentCache) {
                segment.array = null;
                segment.count = 0;
                this.segments.add(segment);
            }
        }
    }

    private static class CachedSegment
    extends Segment {
        private CachedSegment() {
        }
    }
}

