/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class SimpleEUCEncoder
extends CharsetEncoder {
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected String index2b;
    protected String index2c;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private byte[] outputByte = new byte[4];
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SimpleEUCEncoder(Charset charset) {
        super(charset, 3.0f, 4.0f);
    }

    public boolean canEncode(char c) {
        String string;
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        if (n < 7500) {
            string = this.index2;
        } else if (n < 15000) {
            n -= 7500;
            string = this.index2a;
        } else if (n < 22500) {
            n -= 15000;
            string = this.index2b;
        } else {
            n -= 22500;
            string = this.index2c;
        }
        if (string.charAt(2 * n) != '\u0000' || string.charAt(2 * n + 1) != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n <= n2);
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            for (n = n <= n2 ? n : n2; n < n2; ++n) {
                int n5;
                int n6;
                Object object;
                boolean bl = true;
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        object = this.sgp.error();
                        return object;
                    }
                    object = this.sgp.unmappableResult();
                    return object;
                }
                if (c >= '\ufffe') {
                    object = CoderResult.unmappableForLength(1);
                    return object;
                }
                int n7 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                if (n7 < 7500) {
                    object = this.index2;
                } else if (n7 < 15000) {
                    n7 -= 7500;
                    object = this.index2a;
                } else if (n7 < 22500) {
                    n7 -= 15000;
                    object = this.index2b;
                } else {
                    n7 -= 22500;
                    object = this.index2c;
                }
                char c2 = ((String)object).charAt(2 * n7);
                this.outputByte[0] = (byte)((c2 & 0xFF00) >> 8);
                this.outputByte[1] = (byte)(c2 & 0xFF);
                c2 = ((String)object).charAt(2 * n7 + 1);
                this.outputByte[2] = (byte)((c2 & 0xFF00) >> 8);
                this.outputByte[3] = (byte)(c2 & 0xFF);
                for (n6 = 0; n6 < this.outputByte.length; ++n6) {
                    if (this.outputByte[n6] == 0) continue;
                    bl = false;
                    break;
                }
                if (bl && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n8 = 0;
                for (n5 = this.outputByte.length; n5 > 1 && this.outputByte[n8++] == 0; --n5) {
                }
                if (n3 + n5 > n4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                for (n6 = this.outputByte.length - n5; n6 < this.outputByte.length; ++n6) {
                    byArray[n3++] = this.outputByte[n6];
                }
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                int n2;
                int n3;
                Object object;
                char c = charBuffer.get();
                boolean bl = true;
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        object = this.sgp.error();
                        return object;
                    }
                    object = this.sgp.unmappableResult();
                    return object;
                }
                if (c >= '\ufffe') {
                    object = CoderResult.unmappableForLength(1);
                    return object;
                }
                int n4 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                if (n4 < 7500) {
                    object = this.index2;
                } else if (n4 < 15000) {
                    n4 -= 7500;
                    object = this.index2a;
                } else if (n4 < 22500) {
                    n4 -= 15000;
                    object = this.index2b;
                } else {
                    n4 -= 22500;
                    object = this.index2c;
                }
                char c2 = ((String)object).charAt(2 * n4);
                this.outputByte[0] = (byte)((c2 & 0xFF00) >> 8);
                this.outputByte[1] = (byte)(c2 & 0xFF);
                c2 = ((String)object).charAt(2 * n4 + 1);
                this.outputByte[2] = (byte)((c2 & 0xFF00) >> 8);
                this.outputByte[3] = (byte)(c2 & 0xFF);
                for (n3 = 0; n3 < this.outputByte.length; ++n3) {
                    if (this.outputByte[n3] == 0) continue;
                    bl = false;
                    break;
                }
                if (bl && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n5 = 0;
                for (n2 = this.outputByte.length; n2 > 1 && this.outputByte[n5++] == 0; --n2) {
                }
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                for (n3 = this.outputByte.length - n2; n3 < this.outputByte.length; ++n3) {
                    byteBuffer.put(this.outputByte[n3]);
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    public byte encode(char c) {
        return (byte)this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
    }
}

