/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;
import sun.misc.CharacterDecoder;

public class UUDecoder
extends CharacterDecoder {
    public String bufferName;
    public int mode;
    private byte[] decoderBuffer = new byte[4];

    protected int bytesPerAtom() {
        return 3;
    }

    protected int bytesPerLine() {
        return 45;
    }

    protected void decodeAtom(PushbackInputStream pushbackInputStream, OutputStream outputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int n2 = pushbackInputStream.read();
            if (n2 == -1) {
                throw new CEStreamExhausted();
            }
            stringBuffer.append((char)n2);
            this.decoderBuffer[i] = (byte)(n2 - 32 & 0x3F);
        }
        int n3 = this.decoderBuffer[0] << 2 & 0xFC | this.decoderBuffer[1] >>> 4 & 3;
        int n4 = this.decoderBuffer[1] << 4 & 0xF0 | this.decoderBuffer[2] >>> 2 & 0xF;
        int n5 = this.decoderBuffer[2] << 6 & 0xC0 | this.decoderBuffer[3] & 0x3F;
        outputStream.write((byte)(n3 & 0xFF));
        if (n > 1) {
            outputStream.write((byte)(n4 & 0xFF));
        }
        if (n > 2) {
            outputStream.write((byte)(n5 & 0xFF));
        }
    }

    protected void decodeBufferPrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(32);
        boolean bl = true;
        while (true) {
            if ((n = pushbackInputStream.read()) == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (n == 98 && bl && (n = pushbackInputStream.read()) == 101) break;
            bl = n == 10 || n == 13;
        }
        while (n != 10 && n != 13) {
            n = pushbackInputStream.read();
            if (n == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (n == 10 || n == 13) continue;
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        if (string.indexOf(32) != 3) {
            throw new CEFormatException("UUDecoder: Malformed begin line.");
        }
        this.mode = Integer.parseInt(string.substring(4, 7));
        this.bufferName = string.substring(string.indexOf(32, 6) + 1);
        if (n == 13 && (n = pushbackInputStream.read()) != 10 && n != -1) {
            pushbackInputStream.unread(n);
        }
    }

    protected int decodeLinePrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n = pushbackInputStream.read();
        if (n == 32) {
            n = pushbackInputStream.read();
            n = pushbackInputStream.read();
            if (n != 10 && n != -1) {
                pushbackInputStream.unread(n);
            }
            throw new CEStreamExhausted();
        }
        if (n == -1) {
            throw new CEFormatException("UUDecoder: Short Buffer.");
        }
        if ((n = n - 32 & 0x3F) > this.bytesPerLine()) {
            throw new CEFormatException("UUDecoder: Bad Line Length.");
        }
        return n;
    }

    protected void decodeLineSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        block3: {
            int n;
            do {
                if ((n = pushbackInputStream.read()) == -1) {
                    throw new CEStreamExhausted();
                }
                if (n == 10) break block3;
            } while (n != 13);
            n = pushbackInputStream.read();
            if (n != 10 && n != -1) {
                pushbackInputStream.unread(n);
            }
        }
    }

    protected void decodeBufferSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n = pushbackInputStream.read(this.decoderBuffer);
        if (this.decoderBuffer[0] != 101 || this.decoderBuffer[1] != 110 || this.decoderBuffer[2] != 100) {
            throw new CEFormatException("UUDecoder: Missing 'end' line.");
        }
    }
}

