/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import java.net.InetAddress;
import java.net.UnknownHostException;
import sun.management.snmp.jvminstr.NotificationTarget;

public class NotificationTargetImpl
implements NotificationTarget {
    private InetAddress address;
    private int port;
    private String community;

    public NotificationTargetImpl(String string) throws IllegalArgumentException, UnknownHostException {
        this.parseTarget(string);
    }

    public NotificationTargetImpl(String string, int n, String string2) throws UnknownHostException {
        this(InetAddress.getByName(string), n, string2);
    }

    public NotificationTargetImpl(InetAddress inetAddress, int n, String string) {
        this.address = inetAddress;
        this.port = n;
        this.community = string;
    }

    private void parseTarget(String string) throws IllegalArgumentException, UnknownHostException {
        String string2;
        int n;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid target [" + string + "]");
        }
        if (string.startsWith("[")) {
            n = string.indexOf("]");
            int n2 = string.lastIndexOf(":");
            if (n == -1) {
                throw new IllegalArgumentException("Host starts with [ but does not end with ]");
            }
            string2 = string.substring(1, n);
            this.port = Integer.parseInt(string.substring(n + 2, n2));
            if (!NotificationTargetImpl.isNumericIPv6Address(string2)) {
                throw new IllegalArgumentException("Address inside [...] must be numeric IPv6 address");
            }
            if (string2.startsWith("[")) {
                throw new IllegalArgumentException("More than one [[...]]");
            }
        } else {
            n = string.indexOf(":");
            int n3 = string.lastIndexOf(":");
            if (n == -1) {
                throw new IllegalArgumentException("Missing port separator \":\"");
            }
            string2 = string.substring(0, n);
            this.port = Integer.parseInt(string.substring(n + 1, n3));
        }
        this.address = InetAddress.getByName(string2);
        n = string.lastIndexOf(":");
        this.community = string.substring(n + 1, string.length());
    }

    private static boolean isNumericIPv6Address(String string) {
        return string.indexOf(58) >= 0;
    }

    public String getCommunity() {
        return this.community;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "address : " + this.address + " port : " + this.port + " community : " + this.community;
    }
}

