/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryUsage;

public abstract class Sensor {
    private Object lock;
    private String name;
    private long count;
    private boolean on;

    public Sensor(String string) {
        this.name = string;
        this.count = 0L;
        this.on = false;
        this.lock = new Object();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.on;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        Object object = this.lock;
        synchronized (object) {
            this.on = true;
            ++this.count;
        }
        this.triggerAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.on = true;
            this.count += (long)n;
        }
        this.triggerAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(int n, MemoryUsage memoryUsage) {
        Object object = this.lock;
        synchronized (object) {
            this.on = true;
            this.count += (long)n;
        }
        this.triggerAction(memoryUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.on = false;
        }
        this.clearAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.on = false;
            this.count += (long)n;
        }
        this.clearAction();
    }

    public String toString() {
        return "Sensor - " + this.getName() + (this.isOn() ? " on " : " off ") + " count = " + this.getCount();
    }

    abstract void triggerAction();

    abstract void triggerAction(MemoryUsage var1);

    abstract void clearAction();
}

