/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CertPath
implements Serializable {
    private static final long serialVersionUID = 6068470306649138683L;
    private String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator<String> getEncodings();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)object;
        if (!certPath.getType().equals(this.type)) {
            return false;
        }
        List<? extends Certificate> list = this.getCertificates();
        List<? extends Certificate> list2 = certPath.getCertificates();
        return ((Object)list).equals(list2);
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + ((Object)this.getCertificates()).hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<? extends Certificate> iterator = this.getCertificates().iterator();
        stringBuffer.append("\n" + this.type + " Cert Path: length = " + this.getCertificates().size() + ".\n");
        stringBuffer.append("[\n");
        int n = 1;
        while (iterator.hasNext()) {
            stringBuffer.append("=========================================================Certificate " + n + " start.\n");
            Certificate certificate = iterator.next();
            stringBuffer.append(certificate.toString());
            stringBuffer.append("\n=========================================================Certificate " + n + " end.\n\n\n");
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List<? extends Certificate> getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            notSerializableException.initCause(certificateException);
            throw notSerializableException;
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private static final long serialVersionUID = 3015633072427920915L;
        private String type;
        private byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                notSerializableException.initCause(certificateException);
                throw notSerializableException;
            }
        }
    }
}

