/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import java.io.Serializable;

public class LineNumberGen
implements InstructionTargeter,
Cloneable,
Serializable {
    private InstructionHandle ih;
    private int src_line;

    public LineNumberGen(InstructionHandle instructionHandle, int n) {
        this.setInstruction(instructionHandle);
        this.setSourceLine(n);
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.ih == instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (instructionHandle != this.ih) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.ih + "}");
        }
        this.setInstruction(instructionHandle2);
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public void setInstruction(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(int n) {
        this.src_line = n;
    }

    public int getSourceLine() {
        return this.src_line;
    }
}

