/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

class DefaultPreviewPanel
extends JPanel {
    private int squareSize = 25;
    private int squareGap = 5;
    private int innerGap = 5;
    private int textGap = 5;
    private Font font = new Font("Dialog", 0, 12);
    private String sampleText = UIManager.getString("ColorChooser.sampleText");
    private int swatchWidth = 50;
    private Color oldColor = null;

    DefaultPreviewPanel() {
    }

    private JColorChooser getColorChooser() {
        return (JColorChooser)SwingUtilities.getAncestorOfClass(JColorChooser.class, this);
    }

    public Dimension getPreferredSize() {
        JComponent jComponent = this.getColorChooser();
        if (jComponent == null) {
            jComponent = this;
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = SwingUtilities2.stringWidth(jComponent, fontMetrics, this.sampleText);
        int n4 = n2 * 3 + this.textGap * 3;
        int n5 = this.squareSize * 3 + this.squareGap * 2 + this.swatchWidth + n3 + this.textGap * 3;
        return new Dimension(n5, n4);
    }

    public void paintComponent(Graphics graphics) {
        if (this.oldColor == null) {
            this.oldColor = this.getForeground();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getComponentOrientation().isLeftToRight()) {
            int n = this.paintSquares(graphics, 0);
            int n2 = this.paintText(graphics, n);
            this.paintSwatch(graphics, n + n2);
        } else {
            int n = this.paintSwatch(graphics, 0);
            int n3 = this.paintText(graphics, n);
            this.paintSquares(graphics, n + n3);
        }
    }

    private int paintSwatch(Graphics graphics, int n) {
        int n2 = n;
        graphics.setColor(this.oldColor);
        graphics.fillRect(n2, 0, this.swatchWidth, this.squareSize + this.squareGap / 2);
        graphics.setColor(this.getForeground());
        graphics.fillRect(n2, this.squareSize + this.squareGap / 2, this.swatchWidth, this.squareSize + this.squareGap / 2);
        return n2 + this.swatchWidth;
    }

    private int paintText(Graphics graphics, int n) {
        graphics.setFont(this.getFont());
        JComponent jComponent = this.getColorChooser();
        if (jComponent == null) {
            jComponent = this;
        }
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics.getHeight();
        int n4 = SwingUtilities2.stringWidth(jComponent, fontMetrics, this.sampleText);
        int n5 = n + this.textGap;
        Color color = this.getForeground();
        graphics.setColor(color);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n5 + this.textGap / 2, n2 + 2);
        graphics.fillRect(n5, n3 + this.textGap, n4 + this.textGap, n3 + 2);
        graphics.setColor(Color.black);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n5 + this.textGap / 2, n3 + n2 + this.textGap + 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n5, (n3 + this.textGap) * 2, n4 + this.textGap, n3 + 2);
        graphics.setColor(color);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n5 + this.textGap / 2, (n3 + this.textGap) * 2 + n2 + 2);
        return n4 + this.textGap * 3;
    }

    private int paintSquares(Graphics graphics, int n) {
        int n2 = n;
        Color color = this.getForeground();
        graphics.setColor(Color.white);
        graphics.fillRect(n2, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n2 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n2 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.setColor(color);
        graphics.fillRect(n2, this.squareSize + this.squareGap, this.squareSize, this.squareSize);
        graphics.translate(this.squareSize + this.squareGap, 0);
        graphics.setColor(Color.black);
        graphics.fillRect(n2, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n2 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n2 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-(this.squareSize + this.squareGap), 0);
        graphics.translate(this.squareSize + this.squareGap, this.squareSize + this.squareGap);
        graphics.setColor(Color.white);
        graphics.fillRect(n2, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n2 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-(this.squareSize + this.squareGap), -(this.squareSize + this.squareGap));
        graphics.translate((this.squareSize + this.squareGap) * 2, 0);
        graphics.setColor(Color.white);
        graphics.fillRect(n2, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n2 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.black);
        graphics.fillRect(n2 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), 0);
        graphics.translate((this.squareSize + this.squareGap) * 2, this.squareSize + this.squareGap);
        graphics.setColor(Color.black);
        graphics.fillRect(n2, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n2 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), -(this.squareSize + this.squareGap));
        return this.squareSize * 3 + this.squareGap * 2;
    }
}

