/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue<Future<V>> completionQueue;

    private RunnableFuture<V> newTaskFor(Callable<V> callable) {
        if (this.aes == null) {
            return new FutureTask<V>(callable);
        }
        return this.aes.newTaskFor(callable);
    }

    private RunnableFuture<V> newTaskFor(Runnable runnable, V v) {
        if (this.aes == null) {
            return new FutureTask<V>(runnable, v);
        }
        return this.aes.newTaskFor(runnable, v);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = blockingQueue;
    }

    @Override
    public Future<V> submit(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<V> runnableFuture = this.newTaskFor(callable);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    @Override
    public Future<V> submit(Runnable runnable, V v) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<V> runnableFuture = this.newTaskFor(runnable, v);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.completionQueue.poll(l, timeUnit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueingFuture
    extends FutureTask<Void> {
        private final Future<V> task;

        QueueingFuture(RunnableFuture<V> runnableFuture) {
            super(runnableFuture, null);
            this.task = runnableFuture;
        }

        @Override
        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

