/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeQualifiedFieldAccessorImpl;

class UnsafeQualifiedFloatFieldAccessorImpl
extends UnsafeQualifiedFieldAccessorImpl {
    UnsafeQualifiedFloatFieldAccessorImpl(Field field, boolean bl) {
        super(field, bl);
    }

    public Object get(Object object) throws IllegalArgumentException {
        return new Float(this.getFloat(object));
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    public byte getByte(Object object) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    public char getChar(Object object) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    public short getShort(Object object) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    public int getInt(Object object) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    public long getLong(Object object) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    public float getFloat(Object object) throws IllegalArgumentException {
        this.ensureObj(object);
        return unsafe.getFloatVolatile(object, this.fieldOffset);
    }

    public double getDouble(Object object) throws IllegalArgumentException {
        return this.getFloat(object);
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(object2);
        }
        if (object2 == null) {
            this.throwSetIllegalArgumentException(object2);
        }
        if (object2 instanceof Byte) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Byte)object2).byteValue());
            return;
        }
        if (object2 instanceof Short) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Short)object2).shortValue());
            return;
        }
        if (object2 instanceof Character) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Character)object2).charValue());
            return;
        }
        if (object2 instanceof Integer) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Integer)object2).intValue());
            return;
        }
        if (object2 instanceof Long) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Long)object2).longValue());
            return;
        }
        if (object2 instanceof Float) {
            unsafe.putFloatVolatile(object, this.fieldOffset, ((Float)object2).floatValue());
            return;
        }
        this.throwSetIllegalArgumentException(object2);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(bl);
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, by);
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, c);
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, s);
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, n);
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, l);
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(f);
        }
        unsafe.putFloatVolatile(object, this.fieldOffset, f);
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

