/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private Vector visibleNodes;
    private boolean updateNodeSizes;
    private TreeStateNode root;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private Stack tempStacks = new Stack();

    public VariableHeightLayoutCache() {
        this.visibleNodes = new Vector();
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild(false);
    }

    @Override
    public void setRootVisible(boolean bl) {
        if (this.isRootVisible() != bl && this.root != null) {
            if (bl) {
                this.root.updatePreferredSize(0);
                this.visibleNodes.insertElementAt(this.root, 0);
            } else if (this.visibleNodes.size() > 0) {
                this.visibleNodes.removeElementAt(0);
                if (this.treeSelectionModel != null) {
                    this.treeSelectionModel.removeSelectionPath(this.root.getTreePath());
                }
            }
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.resetRowSelection();
            }
            if (this.getRowCount() > 0) {
                this.getNode(0).setYOrigin(0);
            }
            this.updateYLocationsFrom(0);
            this.visibleNodesChanged();
        }
        super.setRootVisible(bl);
    }

    @Override
    public void setRowHeight(int n) {
        if (n != this.getRowHeight()) {
            super.setRowHeight(n);
            this.invalidateSizes();
            this.visibleNodesChanged();
        }
    }

    @Override
    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nodeDimensions) {
        super.setNodeDimensions(nodeDimensions);
        this.invalidateSizes();
        this.visibleNodesChanged();
    }

    @Override
    public void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath != null) {
            if (bl) {
                this.ensurePathIsExpanded(treePath, true);
            } else {
                TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, true);
                if (treeStateNode != null) {
                    treeStateNode.makeVisible();
                    treeStateNode.collapse();
                }
            }
        }
    }

    @Override
    public boolean getExpandedState(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.isVisible() && treeStateNode.isExpanded() : false;
    }

    @Override
    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            if (this.updateNodeSizes) {
                this.updateNodeSizes(false);
            }
            return treeStateNode.getNodeBounds(rectangle);
        }
        return null;
    }

    @Override
    public TreePath getPathForRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.getNode(n).getTreePath();
        }
        return null;
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        if (treePath == null) {
            return -1;
        }
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return treeStateNode.getRow();
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.visibleNodes.size();
    }

    @Override
    public void invalidatePathBounds(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            treeStateNode.markSizeInvalid();
            if (treeStateNode.isVisible()) {
                this.updateYLocationsFrom(treeStateNode.getRow());
            }
        }
    }

    @Override
    public int getPreferredHeight() {
        int n = this.getRowCount();
        if (n > 0) {
            TreeStateNode treeStateNode = this.getNode(n - 1);
            return treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
        }
        return 0;
    }

    @Override
    public int getPreferredWidth(Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        return this.getMaxNodeWidth();
    }

    @Override
    public TreePath getPathClosestTo(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        int n3 = this.getRowContainingYLocation(n2);
        return this.getNode(n3).getTreePath();
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return new VisibleTreeStateNodeEnumeration(treeStateNode);
        }
        return null;
    }

    @Override
    public int getVisibleChildCount(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.getVisibleChildCount() : 0;
    }

    @Override
    public void invalidateSizes() {
        if (this.root != null) {
            this.root.deepMarkSizeInvalid();
        }
        if (!this.isFixedRowHeight() && this.visibleNodes.size() > 0) {
            this.updateNodeSizes(true);
        }
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
            return treeStateNode != null && treeStateNode.isExpanded();
        }
        return false;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null) {
                int n;
                Object object = treeStateNode.getValue();
                treeStateNode.updatePreferredSize();
                if (treeStateNode.hasBeenExpanded() && nArray != null) {
                    for (n = 0; n < nArray.length; ++n) {
                        TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[n]);
                        treeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[n]));
                        treeStateNode2.updatePreferredSize();
                    }
                } else if (treeStateNode == this.root) {
                    treeStateNode.updatePreferredSize();
                }
                if (!this.isFixedRowHeight() && (n = treeStateNode.getRow()) != -1) {
                    this.updateYLocationsFrom(n);
                }
                this.visibleNodesChanged();
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    int n = treeStateNode.getChildCount();
                    Object object = treeStateNode.getValue();
                    boolean bl = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    for (int i = 0; i < nArray.length; ++i) {
                        TreeStateNode treeStateNode2 = this.createNodeAt(treeStateNode, nArray[i]);
                    }
                    if (n == 0) {
                        treeStateNode.updatePreferredSize();
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl || n == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) - nArray.length == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    boolean bl = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n;
                        TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[i]);
                        if (treeStateNode2.isExpanded()) {
                            treeStateNode2.collapse(false);
                        }
                        if (bl && (n = treeStateNode2.getRow()) != -1) {
                            this.visibleNodes.removeElementAt(n);
                        }
                        treeStateNode.remove(nArray[i]);
                    }
                    if (treeStateNode.getChildCount() == 0) {
                        treeStateNode.updatePreferredSize();
                        if (treeStateNode.isExpanded() && treeStateNode.isLeaf()) {
                            treeStateNode.collapse(false);
                        }
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl || treeStateNode.getChildCount() == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            if (this.getRowCount() > 0) {
                                this.getNode(0).setYOrigin(0);
                            }
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = treeModelEvent.getTreePath();
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, false);
            if (treeStateNode == this.root || treeStateNode == null && (treePath == null && this.treeModel != null && this.treeModel.getRoot() == null || treePath != null && treePath.getPathCount() == 1)) {
                this.rebuild(true);
            } else if (treeStateNode != null) {
                boolean bl = treeStateNode.isExpanded();
                boolean bl2 = treeStateNode.getRow() != -1;
                TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getParent();
                int n = treeStateNode2.getIndex(treeStateNode);
                if (bl2 && bl) {
                    treeStateNode.collapse(false);
                }
                if (bl2) {
                    this.visibleNodes.removeElement(treeStateNode);
                }
                treeStateNode.removeFromParent();
                this.createNodeAt(treeStateNode2, n);
                TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode2.getChildAt(n);
                if (bl2 && bl) {
                    treeStateNode3.expand(false);
                }
                int n2 = treeStateNode3.getRow();
                if (!this.isFixedRowHeight() && bl2) {
                    if (n2 == 0) {
                        this.updateYLocationsFrom(n2);
                    } else {
                        this.updateYLocationsFrom(n2 - 1);
                    }
                    this.visibleNodesChanged();
                } else if (bl2) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private void addMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.put(treeStateNode.getTreePath(), treeStateNode);
    }

    private void removeMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.remove(treeStateNode.getTreePath());
    }

    private TreeStateNode getMapping(TreePath treePath) {
        return (TreeStateNode)this.treePathMapping.get(treePath);
    }

    private Rectangle getBounds(int n, Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        if (n >= 0 && n < this.getRowCount()) {
            return this.getNode(n).getNodeBounds(rectangle);
        }
        return null;
    }

    private void rebuild(boolean bl) {
        Object object;
        this.treePathMapping.clear();
        if (this.treeModel != null && (object = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(object);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            this.root.updatePreferredSize(0);
            this.visibleNodes.removeAllElements();
            if (this.isRootVisible()) {
                this.visibleNodes.addElement(this.root);
            }
            if (!this.root.isExpanded()) {
                this.root.expand();
            } else {
                Enumeration enumeration = this.root.children();
                while (enumeration.hasMoreElements()) {
                    this.visibleNodes.addElement(enumeration.nextElement());
                }
                if (!this.isFixedRowHeight()) {
                    this.updateYLocationsFrom(0);
                }
            }
        } else {
            this.visibleNodes.removeAllElements();
            this.root = null;
        }
        if (bl && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private TreeStateNode createNodeAt(TreeStateNode treeStateNode, int n) {
        boolean bl;
        Object object = this.treeModel.getChild(treeStateNode.getValue(), n);
        TreeStateNode treeStateNode2 = this.createNodeForValue(object);
        treeStateNode.insert(treeStateNode2, n);
        treeStateNode2.updatePreferredSize(-1);
        boolean bl2 = bl = treeStateNode == this.root;
        if (treeStateNode2 != null && treeStateNode.isExpanded() && (treeStateNode.getRow() != -1 || bl)) {
            int n2;
            if (n == 0) {
                n2 = bl && !this.isRootVisible() ? 0 : treeStateNode.getRow() + 1;
            } else if (n == treeStateNode.getChildCount()) {
                n2 = treeStateNode.getLastVisibleNode().getRow() + 1;
            } else {
                TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode.getChildAt(n - 1);
                n2 = treeStateNode3.getLastVisibleNode().getRow() + 1;
            }
            this.visibleNodes.insertElementAt(treeStateNode2, n2);
        }
        return treeStateNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeStateNode getNodeForPath(TreePath treePath, boolean bl, boolean bl2) {
        if (treePath != null) {
            TreeStateNode treeStateNode;
            TreeStateNode treeStateNode2 = this.getMapping(treePath);
            if (treeStateNode2 != null) {
                if (bl && !treeStateNode2.isVisible()) {
                    return null;
                }
                return treeStateNode2;
            }
            Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
            try {
                stack.push(treePath);
                treeStateNode2 = null;
                for (treePath = treePath.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
                    treeStateNode2 = this.getMapping(treePath);
                    if (treeStateNode2 == null) break block9;
                    while (treeStateNode2 != null && stack.size() > 0) {
                        treePath = (TreePath)stack.pop();
                        treeStateNode2.getLoadedChildren(bl2);
                        int n = this.treeModel.getIndexOfChild(treeStateNode2.getUserObject(), treePath.getLastPathComponent());
                        if (n == -1 || n >= treeStateNode2.getChildCount() || bl && !treeStateNode2.isVisible()) {
                            treeStateNode2 = null;
                            continue;
                        }
                        treeStateNode2 = (TreeStateNode)treeStateNode2.getChildAt(n);
                    }
                    treeStateNode = treeStateNode2;
                    Object var8_8 = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                stack.removeAllElements();
                this.tempStacks.push(stack);
                throw throwable;
            }
            {
                block9: {
                    stack.removeAllElements();
                    this.tempStacks.push(stack);
                    return treeStateNode;
                }
                stack.push(treePath);
                continue;
            }
            Object var8_9 = null;
            stack.removeAllElements();
            this.tempStacks.push(stack);
            {
            }
        }
        return null;
    }

    private void updateYLocationsFrom(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            TreeStateNode treeStateNode = this.getNode(n);
            int n2 = treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
            int n3 = this.visibleNodes.size();
            for (int i = n + 1; i < n3; ++i) {
                treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(i);
                treeStateNode.setYOrigin(n2);
                n2 += treeStateNode.getPreferredHeight();
            }
        }
    }

    private void updateNodeSizes(boolean bl) {
        this.updateNodeSizes = false;
        int n = 0;
        int n2 = this.visibleNodes.size();
        for (int i = 0; i < n2; ++i) {
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(i);
            treeStateNode.setYOrigin(n);
            if (bl || !treeStateNode.hasValidSize()) {
                treeStateNode.updatePreferredSize(i);
            }
            n += treeStateNode.getPreferredHeight();
        }
    }

    private int getRowContainingYLocation(int n) {
        if (this.isFixedRowHeight()) {
            if (this.getRowCount() == 0) {
                return -1;
            }
            return Math.max(0, Math.min(this.getRowCount() - 1, n / this.getRowHeight()));
        }
        int n2 = this.getRowCount();
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = (n2 - n3) / 2 + n3;
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(n4);
            int n5 = treeStateNode.getYOrigin();
            int n6 = n5 + treeStateNode.getPreferredHeight();
            if (n < n5) {
                n2 = n4 - 1;
                continue;
            }
            if (n < n6) break;
            n3 = n4 + 1;
        }
        if (n3 == n2 && (n4 = n3) >= this.getRowCount()) {
            n4 = this.getRowCount() - 1;
        }
        return n4;
    }

    private void ensurePathIsExpanded(TreePath treePath, boolean bl) {
        if (treePath != null) {
            TreeStateNode treeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl = true;
            }
            if (treePath != null && (treeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                treeStateNode.makeVisible();
                if (bl) {
                    treeStateNode.expand();
                }
            }
        }
    }

    private TreeStateNode getNode(int n) {
        return (TreeStateNode)this.visibleNodes.elementAt(n);
    }

    private int getMaxNodeWidth() {
        int n = 0;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            TreeStateNode treeStateNode = this.getNode(i);
            int n2 = treeStateNode.getPreferredWidth() + treeStateNode.getXOrigin();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private TreeStateNode createNodeForValue(Object object) {
        return new TreeStateNode(object);
    }

    private class TreeStateNode
    extends DefaultMutableTreeNode {
        protected int preferredWidth;
        protected int preferredHeight;
        protected int xOrigin;
        protected int yOrigin;
        protected boolean expanded;
        protected boolean hasBeenExpanded;
        protected TreePath path;

        public TreeStateNode(Object object) {
            super(object);
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((TreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                VariableHeightLayoutCache.this.addMapping(this);
            }
        }

        public void remove(int n) {
            TreeStateNode treeStateNode = (TreeStateNode)this.getChildAt(n);
            treeStateNode.removeFromMapping();
            super.remove(n);
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
                if (treeStateNode != null) {
                    this.resetChildrenPaths(treeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public Enumeration children() {
            if (!this.isExpanded()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return super.children();
        }

        public boolean isLeaf() {
            return VariableHeightLayoutCache.this.getModel().isLeaf(this.getValue());
        }

        public Rectangle getNodeBounds(Rectangle rectangle) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.getXOrigin(), this.getYOrigin(), this.getPreferredWidth(), this.getPreferredHeight());
            } else {
                rectangle.x = this.getXOrigin();
                rectangle.y = this.getYOrigin();
                rectangle.width = this.getPreferredWidth();
                rectangle.height = this.getPreferredHeight();
            }
            return rectangle;
        }

        public int getXOrigin() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.xOrigin;
        }

        public int getYOrigin() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                int n = this.getRow();
                if (n == -1) {
                    return -1;
                }
                return VariableHeightLayoutCache.this.getRowHeight() * n;
            }
            return this.yOrigin;
        }

        public int getPreferredHeight() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                return VariableHeightLayoutCache.this.getRowHeight();
            }
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredHeight;
        }

        public int getPreferredWidth() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredWidth;
        }

        public boolean hasValidSize() {
            return this.preferredHeight != 0;
        }

        public int getRow() {
            return VariableHeightLayoutCache.this.visibleNodes.indexOf(this);
        }

        public boolean hasBeenExpanded() {
            return this.hasBeenExpanded;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public TreeStateNode getLastVisibleNode() {
            TreeStateNode treeStateNode = this;
            while (treeStateNode.isExpanded() && treeStateNode.getChildCount() > 0) {
                treeStateNode = (TreeStateNode)treeStateNode.getLastChild();
            }
            return treeStateNode;
        }

        public boolean isVisible() {
            if (this == VariableHeightLayoutCache.this.root) {
                return true;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            return treeStateNode != null && treeStateNode.isExpanded() && treeStateNode.isVisible();
        }

        public int getModelChildCount() {
            if (this.hasBeenExpanded) {
                return super.getChildCount();
            }
            return VariableHeightLayoutCache.this.getModel().getChildCount(this.getValue());
        }

        public int getVisibleChildCount() {
            int n = 0;
            if (this.isExpanded()) {
                int n2 = this.getChildCount();
                n += n2;
                for (int i = 0; i < n2; ++i) {
                    n += ((TreeStateNode)this.getChildAt(i)).getVisibleChildCount();
                }
            }
            return n;
        }

        public void toggleExpanded() {
            if (this.isExpanded()) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void makeVisible() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
        }

        public void expand() {
            this.expand(true);
        }

        public void collapse() {
            this.collapse(true);
        }

        public Object getValue() {
            return this.getUserObject();
        }

        public TreePath getTreePath() {
            return this.path;
        }

        protected void resetChildrenPaths(TreePath treePath) {
            VariableHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            VariableHeightLayoutCache.this.addMapping(this);
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                ((TreeStateNode)this.getChildAt(i)).resetChildrenPaths(this.path);
            }
        }

        protected void setYOrigin(int n) {
            this.yOrigin = n;
        }

        protected void shiftYOriginBy(int n) {
            this.yOrigin += n;
        }

        protected void updatePreferredSize() {
            this.updatePreferredSize(this.getRow());
        }

        protected void updatePreferredSize(int n) {
            Rectangle rectangle = VariableHeightLayoutCache.this.getNodeDimensions(this.getUserObject(), n, this.getLevel(), this.isExpanded(), VariableHeightLayoutCache.this.boundsBuffer);
            if (rectangle == null) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else if (rectangle.height == 0) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else {
                this.xOrigin = rectangle.x;
                this.preferredWidth = rectangle.width;
                this.preferredHeight = VariableHeightLayoutCache.this.isFixedRowHeight() ? VariableHeightLayoutCache.this.getRowHeight() : rectangle.height;
            }
        }

        protected void markSizeInvalid() {
            this.preferredHeight = 0;
        }

        protected void deepMarkSizeInvalid() {
            this.markSizeInvalid();
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                ((TreeStateNode)this.getChildAt(i)).deepMarkSizeInvalid();
            }
        }

        protected Enumeration getLoadedChildren(boolean bl) {
            if (!bl || this.hasBeenExpanded) {
                return super.children();
            }
            Object object = this.getValue();
            TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
            int n = treeModel.getChildCount(object);
            this.hasBeenExpanded = true;
            int n2 = this.getRow();
            if (n2 == -1) {
                for (int i = 0; i < n; ++i) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, i));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(-1);
                }
            } else {
                ++n2;
                for (int i = 0; i < n; ++i) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, i));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(n2++);
                }
            }
            return super.children();
        }

        protected void didAdjustTree() {
        }

        protected void expandParentAndReceiver() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand(boolean bl) {
            if (!this.isExpanded() && !this.isLeaf()) {
                int n;
                int n2;
                Object object;
                boolean bl2 = VariableHeightLayoutCache.this.isFixedRowHeight();
                int n3 = this.getPreferredHeight();
                int n4 = this.getRow();
                this.expanded = true;
                this.updatePreferredSize(n4);
                if (!this.hasBeenExpanded) {
                    TreeStateNode treeStateNode;
                    object = this.getValue();
                    TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
                    int n5 = treeModel.getChildCount(object);
                    this.hasBeenExpanded = true;
                    if (n4 == -1) {
                        for (n2 = 0; n2 < n5; ++n2) {
                            treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, n2));
                            this.add(treeStateNode);
                            treeStateNode.updatePreferredSize(-1);
                        }
                    } else {
                        n2 = n4 + 1;
                        for (n = 0; n < n5; ++n) {
                            treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, n));
                            this.add(treeStateNode);
                            treeStateNode.updatePreferredSize(n2);
                        }
                    }
                }
                int n6 = n4;
                object = this.preorderEnumeration();
                object.nextElement();
                int n7 = bl2 ? 0 : (this == VariableHeightLayoutCache.this.root && !VariableHeightLayoutCache.this.isRootVisible() ? 0 : this.getYOrigin() + this.getPreferredHeight());
                if (!bl2) {
                    while (object.hasMoreElements()) {
                        TreeStateNode treeStateNode = (TreeStateNode)object.nextElement();
                        if (!VariableHeightLayoutCache.this.updateNodeSizes && !treeStateNode.hasValidSize()) {
                            treeStateNode.updatePreferredSize(n6 + 1);
                        }
                        treeStateNode.setYOrigin(n7);
                        n7 += treeStateNode.getPreferredHeight();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(treeStateNode, ++n6);
                    }
                } else {
                    while (object.hasMoreElements()) {
                        TreeStateNode treeStateNode = (TreeStateNode)object.nextElement();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(treeStateNode, ++n6);
                    }
                }
                if (bl && (n4 != n6 || this.getPreferredHeight() != n3)) {
                    if (!bl2 && ++n6 < VariableHeightLayoutCache.this.getRowCount()) {
                        n = n7 - (this.getYOrigin() + this.getPreferredHeight()) + (this.getPreferredHeight() - n3);
                        for (n2 = VariableHeightLayoutCache.this.visibleNodes.size() - 1; n2 >= n6; --n2) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(n2)).shiftYOriginBy(n);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean bl) {
            if (this.isExpanded()) {
                int n;
                TreeStateNode treeStateNode;
                Enumeration enumeration = this.preorderEnumeration();
                enumeration.nextElement();
                int n2 = 0;
                boolean bl2 = VariableHeightLayoutCache.this.isFixedRowHeight();
                int n3 = bl2 ? 0 : this.getPreferredHeight() + this.getYOrigin();
                int n4 = this.getPreferredHeight();
                int n5 = n3;
                int n6 = this.getRow();
                if (!bl2) {
                    while (enumeration.hasMoreElements()) {
                        treeStateNode = (TreeStateNode)enumeration.nextElement();
                        if (!treeStateNode.isVisible()) continue;
                        ++n2;
                        n3 = treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
                    }
                } else {
                    while (enumeration.hasMoreElements()) {
                        treeStateNode = (TreeStateNode)enumeration.nextElement();
                        if (!treeStateNode.isVisible()) continue;
                        ++n2;
                    }
                }
                for (n = n2 + n6; n > n6; --n) {
                    VariableHeightLayoutCache.this.visibleNodes.removeElementAt(n);
                }
                this.expanded = false;
                if (n6 == -1) {
                    this.markSizeInvalid();
                } else if (bl) {
                    this.updatePreferredSize(n6);
                }
                if (n6 != -1 && bl && (n2 > 0 || n4 != this.getPreferredHeight())) {
                    if (!bl2 && n6 + 1 < VariableHeightLayoutCache.this.getRowCount() && (n5 += this.getPreferredHeight() - n4) != n3) {
                        int n7 = n5 - n3;
                        int n8 = VariableHeightLayoutCache.this.visibleNodes.size();
                        for (n = n6 + 1; n < n8; ++n) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(n)).shiftYOriginBy(n7);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null && n2 > 0 && n6 != -1) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                VariableHeightLayoutCache.this.removeMapping(this);
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    ((TreeStateNode)this.getChildAt(i)).removeFromMapping();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisibleTreeStateNodeEnumeration
    implements Enumeration<TreePath> {
        protected TreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleTreeStateNodeEnumeration(TreeStateNode treeStateNode) {
            this(treeStateNode, -1);
        }

        protected VisibleTreeStateNodeEnumeration(TreeStateNode treeStateNode, int n) {
            this.parent = treeStateNode;
            this.nextIndex = n;
            this.childCount = this.parent.getChildCount();
        }

        @Override
        public boolean hasMoreElements() {
            return this.parent != null;
        }

        @Override
        public TreePath nextElement() {
            TreePath treePath;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            if (this.nextIndex == -1) {
                treePath = this.parent.getTreePath();
            } else {
                TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
                treePath = treeStateNode.getTreePath();
            }
            this.updateNextObject();
            return treePath;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == VariableHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                TreeStateNode treeStateNode = (TreeStateNode)this.parent.getParent();
                if (treeStateNode != null) {
                    this.nextIndex = treeStateNode.getIndex(this.parent);
                    this.parent = treeStateNode;
                    this.childCount = this.parent.getChildCount();
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
            if (treeStateNode != null && treeStateNode.isExpanded()) {
                this.parent = treeStateNode;
                this.nextIndex = -1;
                this.childCount = treeStateNode.getChildCount();
            }
            return true;
        }
    }
}

