/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JDK13Services {
    private static final long DEFAULT_CACHING_PERIOD = 60000L;
    private static final String PROPERTIES_FILENAME = "sound.properties";
    private static Map providersCacheMap = new HashMap();
    private static long cachingPeriod = 60000L;
    private static Properties properties;

    private JDK13Services() {
    }

    public static void setCachingPeriod(int n) {
        cachingPeriod = (long)n * 1000L;
    }

    public static synchronized List getProviders(Class clazz) {
        ProviderCache providerCache = (ProviderCache)providersCacheMap.get(clazz);
        if (providerCache == null) {
            providerCache = new ProviderCache();
            providersCacheMap.put(clazz, providerCache);
        }
        if (providerCache.providers == null || System.currentTimeMillis() > providerCache.lastUpdate + cachingPeriod) {
            providerCache.providers = Collections.unmodifiableList(JSSecurityManager.getProviders(clazz));
            providerCache.lastUpdate = System.currentTimeMillis();
        }
        return providerCache.providers;
    }

    public static synchronized String getDefaultProviderClassName(Class clazz) {
        int n;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n = string2.indexOf(35)) != 0) {
            string = n > 0 ? string2.substring(0, n) : string2;
        }
        return string;
    }

    public static synchronized String getDefaultInstanceName(Class clazz) {
        int n;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n = string2.indexOf(35)) >= 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    private static synchronized String getDefaultProvider(Class clazz) {
        if (!(SourceDataLine.class.equals((Object)clazz) || TargetDataLine.class.equals((Object)clazz) || Clip.class.equals((Object)clazz) || Port.class.equals((Object)clazz) || Receiver.class.equals((Object)clazz) || Transmitter.class.equals((Object)clazz) || Synthesizer.class.equals((Object)clazz) || Sequencer.class.equals((Object)clazz))) {
            return null;
        }
        String string = clazz.getName();
        String string2 = JSSecurityManager.getProperty(string);
        if (string2 == null) {
            string2 = JDK13Services.getProperties().getProperty(string);
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        return string2;
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            JSSecurityManager.loadProperties(properties, PROPERTIES_FILENAME);
        }
        return properties;
    }

    private static class ProviderCache {
        public long lastUpdate;
        public List providers;

        private ProviderCache() {
        }
    }
}

