/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsEnumerator;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Permissions
extends PermissionCollection
implements Serializable {
    private transient Map<Class<?>, PermissionCollection> permsMap = new HashMap(11);
    private transient boolean hasUnresolved = false;
    PermissionCollection allPermission = null;
    private static final long serialVersionUID = 4858622370623524688L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", Hashtable.class), new ObjectStreamField("allPermission", PermissionCollection.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        PermissionCollection permissionCollection;
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        Permissions permissions = this;
        synchronized (permissions) {
            permissionCollection = this.getPermissionCollection(permission, true);
            permissionCollection.add(permission);
        }
        if (permission instanceof AllPermission) {
            this.allPermission = permissionCollection;
        }
        if (permission instanceof UnresolvedPermission) {
            this.hasUnresolved = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (this.allPermission != null) {
            return true;
        }
        Permissions permissions = this;
        synchronized (permissions) {
            PermissionCollection permissionCollection = this.getPermissionCollection(permission, false);
            if (permissionCollection != null) {
                return permissionCollection.implies(permission);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        Permissions permissions = this;
        synchronized (permissions) {
            return new PermissionsEnumerator(this.permsMap.values().iterator());
        }
    }

    private PermissionCollection getPermissionCollection(Permission permission, boolean bl) {
        Class<?> clazz = permission.getClass();
        PermissionCollection permissionCollection = this.permsMap.get(clazz);
        if (!this.hasUnresolved && !bl) {
            return permissionCollection;
        }
        if (permissionCollection == null) {
            PermissionCollection permissionCollection2 = permissionCollection = this.hasUnresolved ? this.getUnresolvedPermissions(permission) : null;
            if (permissionCollection == null && bl && (permissionCollection = permission.newPermissionCollection()) == null) {
                permissionCollection = new PermissionsHash();
            }
            if (permissionCollection != null) {
                this.permsMap.put(clazz, permissionCollection);
            }
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getUnresolvedPermissions(Permission permission) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.permsMap.get(UnresolvedPermission.class);
        if (unresolvedPermissionCollection == null) {
            return null;
        }
        List list = unresolvedPermissionCollection.getUnresolvedPermissions(permission);
        if (list == null) {
            return null;
        }
        Certificate[] certificateArray = null;
        Object[] objectArray = permission.getClass().getSigners();
        int n = 0;
        if (objectArray != null) {
            int n2;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!(objectArray[n2] instanceof Certificate)) continue;
                ++n;
            }
            certificateArray = new Certificate[n];
            n = 0;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!(objectArray[n2] instanceof Certificate)) continue;
                certificateArray[n++] = (Certificate)objectArray[n2];
            }
        }
        PermissionCollection permissionCollection = null;
        List list2 = list;
        synchronized (list2) {
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                UnresolvedPermission unresolvedPermission = (UnresolvedPermission)list.get(i);
                Permission permission2 = unresolvedPermission.resolve(permission, certificateArray);
                if (permission2 == null) continue;
                if (permissionCollection == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                    permissionCollection = new PermissionsHash();
                }
                permissionCollection.add(permission2);
            }
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.permsMap.size() * 2);
        Object object = this;
        synchronized (object) {
            hashtable.putAll(this.permsMap);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("allPermission", this.allPermission);
        ((ObjectOutputStream.PutField)object).put("perms", hashtable);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.allPermission = (PermissionCollection)getField.get("allPermission", null);
        Hashtable hashtable = (Hashtable)getField.get("perms", null);
        this.permsMap = new HashMap(hashtable.size() * 2);
        this.permsMap.putAll(hashtable);
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.permsMap.get(UnresolvedPermission.class);
        this.hasUnresolved = unresolvedPermissionCollection != null && unresolvedPermissionCollection.elements().hasMoreElements();
    }
}

