/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openoffice.setup.Dialogs.DetailsDialog;
import org.openoffice.setup.Dialogs.HelpDialog;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.AbortInstaller;

public class SetupActionListener
implements ActionListener {
    private SetupFrame setupFrame;

    public SetupActionListener(SetupFrame setup) {
        this.setupFrame = setup;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("ActionCancel")) {
            InstallData data = InstallData.getInstance();
            String StringCancelDialog = data.isInstallationMode() ? ResourceManager.getString("String_Cancel_Dialog") : ResourceManager.getString("String_Cancel_Dialog_Uninstallation");
            String StringCancelDialogTitle = ResourceManager.getString("String_Cancel_Dialog_Title");
            JDialog dialog = this.setupFrame.getDialog();
            int n = JOptionPane.showConfirmDialog(dialog, StringCancelDialog, StringCancelDialogTitle, 0);
            if (n == 0) {
                this.setupFrame.close(1);
            }
            this.setupFrame.setButtonSelected(3);
        } else if (evt.getActionCommand().equals("ActionStop")) {
            String StringStopDialogTitle;
            String StringStopDialog;
            InstallData data = InstallData.getInstance();
            if (data.isInstallationMode()) {
                StringStopDialog = ResourceManager.getString("String_Stop_Dialog");
                StringStopDialogTitle = ResourceManager.getString("String_Stop_Dialog_Title");
            } else {
                StringStopDialog = ResourceManager.getString("String_Stop_Dialog_Uninstallation");
                StringStopDialogTitle = ResourceManager.getString("String_Stop_Dialog_Title_Uninstallation");
            }
            JDialog dialog = this.setupFrame.getDialog();
            int n = JOptionPane.showConfirmDialog(dialog, StringStopDialog, StringStopDialogTitle, 0);
            if (n == 0) {
                AbortInstaller.abortInstallProcess();
            }
            this.setupFrame.setButtonSelected(4);
        } else if (evt.getActionCommand().equals("ActionPrevious")) {
            PanelController panel = this.setupFrame.getCurrentPanel();
            String previous = panel.getPrevious();
            this.setupFrame.setCurrentPanel(previous, true, false);
        } else if (evt.getActionCommand().equals("ActionNext")) {
            PanelController panel = this.setupFrame.getCurrentPanel();
            String next = panel.getNext();
            if (next == null) {
                this.setupFrame.close(0);
            } else {
                this.setupFrame.setCurrentPanel(next, false, true);
            }
        } else if (evt.getActionCommand().equals("ActionDetails")) {
            JDialog dialog = this.setupFrame.getDialog();
            DetailsDialog detailsdialog = new DetailsDialog(this.setupFrame);
            detailsdialog.setModal(true);
            detailsdialog.setSize(new Dimension(600, 300));
            detailsdialog.setLocationRelativeTo(dialog);
            detailsdialog.setVisible(true);
            this.setupFrame.setButtonSelected(1);
        } else if (evt.getActionCommand().equals("ActionHelp")) {
            JDialog dialog = this.setupFrame.getDialog();
            HelpDialog helpdialog = new HelpDialog(this.setupFrame);
            helpdialog.setModal(true);
            helpdialog.setSize(new Dimension(400, 300));
            helpdialog.setLocationRelativeTo(dialog);
            helpdialog.setVisible(true);
            this.setupFrame.setButtonSelected(4);
        }
    }
}

