/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.DescriptorCache;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanSupport;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardEmitterMBean;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMBean
implements DynamicMBean,
MBeanRegistration {
    private static final String dbgTag = "StandardMBean";
    private static final DescriptorCache descriptors = DescriptorCache.getInstance(JMX.proof);
    private volatile MBeanSupport<?> mbean;
    private volatile MBeanInfo cachedMBeanInfo;
    private static final Map<Class, Boolean> mbeanInfoSafeMap = new WeakHashMap<Class, Boolean>();

    private <T> void construct(T object, Class<T> clazz, boolean bl, boolean bl2) throws NotCompliantMBeanException {
        if (object == null) {
            if (bl) {
                object = this;
            } else {
                throw new IllegalArgumentException("implementation is null");
            }
        }
        if (bl2) {
            if (clazz == null) {
                clazz = Introspector.getMXBeanInterface(object.getClass());
            }
            this.mbean = new MXBeanSupport(object, clazz);
        } else {
            if (clazz == null) {
                clazz = Introspector.getStandardMBeanInterface(object.getClass());
            }
            this.mbean = new StandardMBeanSupport(object, clazz);
        }
    }

    public <T> StandardMBean(T t, Class<T> clazz) throws NotCompliantMBeanException {
        this.construct(t, clazz, false, false);
    }

    protected StandardMBean(Class<?> clazz) throws NotCompliantMBeanException {
        this.construct(null, clazz, true, false);
    }

    public <T> StandardMBean(T t, Class<T> clazz, boolean bl) {
        try {
            this.construct(t, clazz, false, bl);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
    }

    protected StandardMBean(Class<?> clazz, boolean bl) {
        try {
            this.construct(null, clazz, true, bl);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
    }

    public void setImplementation(Object object) throws NotCompliantMBeanException {
        if (object == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        this.mbean = this.isMXBean() ? new MXBeanSupport(object, this.getMBeanInterface()) : new StandardMBeanSupport(object, this.getMBeanInterface());
    }

    public Object getImplementation() {
        return this.mbean.getResource();
    }

    public final Class<?> getMBeanInterface() {
        return this.mbean.getMBeanInterface();
    }

    public Class<?> getImplementationClass() {
        return this.mbean.getResource().getClass();
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.mbean.getAttribute(string);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbean.setAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        return this.mbean.getAttributes(stringArray);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return this.mbean.setAttributes(attributeList);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return this.mbean.invoke(string, objectArray, stringArray);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Object object;
        try {
            object = this.getCachedMBeanInfo();
            if (object != null) {
                return object;
            }
        }
        catch (RuntimeException runtimeException) {
            StandardMBean.debug("getMBeanInfo", "failed to get cached MBeanInfo: " + runtimeException);
            StandardMBean.debugX("getMBeanInfo", runtimeException);
        }
        if (StandardMBean.isTraceOn()) {
            StandardMBean.trace("getMBeanInfo", "Building MBeanInfo for " + this.getImplementationClass().getName());
        }
        object = this.mbean;
        MBeanInfo mBeanInfo = ((MBeanSupport)object).getMBeanInfo();
        Object object2 = ((MBeanSupport)object).getResource();
        boolean bl = StandardMBean.immutableInfo(this.getClass());
        String string = this.getClassName(mBeanInfo);
        String string2 = this.getDescription(mBeanInfo);
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.getConstructors(mBeanInfo, object2);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getAttributes(mBeanInfo);
        MBeanOperationInfo[] mBeanOperationInfoArray = this.getOperations(mBeanInfo);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.getNotifications(mBeanInfo);
        Descriptor descriptor = this.getDescriptor(mBeanInfo, bl);
        MBeanInfo mBeanInfo2 = new MBeanInfo(string, string2, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray, descriptor);
        try {
            this.cacheMBeanInfo(mBeanInfo2);
        }
        catch (RuntimeException runtimeException) {
            StandardMBean.debug("cacheMBeanInfo", "failed to cache MBeanInfo: " + runtimeException);
            StandardMBean.debugX("cacheMBeanInfo", runtimeException);
        }
        return mBeanInfo2;
    }

    protected String getClassName(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return this.getImplementationClass().getName();
        }
        return mBeanInfo.getClassName();
    }

    protected String getDescription(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return null;
        }
        return mBeanInfo.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo mBeanFeatureInfo) {
        if (mBeanFeatureInfo == null) {
            return null;
        }
        return mBeanFeatureInfo.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanConstructorInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getName();
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanOperationInfo);
    }

    protected int getImpact(MBeanOperationInfo mBeanOperationInfo) {
        if (mBeanOperationInfo == null) {
            return 3;
        }
        return mBeanOperationInfo.getImpact();
    }

    protected String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getName();
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getDescription();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] mBeanConstructorInfoArray, Object object) {
        if (mBeanConstructorInfoArray == null) {
            return null;
        }
        if (object != null && object != this) {
            return null;
        }
        return mBeanConstructorInfoArray;
    }

    MBeanNotificationInfo[] getNotifications(MBeanInfo mBeanInfo) {
        return null;
    }

    Descriptor getDescriptor(MBeanInfo mBeanInfo, boolean bl) {
        ImmutableDescriptor immutableDescriptor = null;
        if (mBeanInfo == null || mBeanInfo.getDescriptor() == null || mBeanInfo.getDescriptor().getFieldNames().length == 0) {
            String string = "interfaceClassName=" + this.getMBeanInterface().getName();
            String string2 = "immutableInfo=" + bl;
            immutableDescriptor = new ImmutableDescriptor(string, string2);
            immutableDescriptor = descriptors.get(immutableDescriptor);
        } else {
            Descriptor descriptor = mBeanInfo.getDescriptor();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : descriptor.getFieldNames()) {
                if (string.equals("immutableInfo")) {
                    hashMap.put(string, Boolean.toString(bl));
                    continue;
                }
                hashMap.put(string, descriptor.getFieldValue(string));
            }
            immutableDescriptor = new ImmutableDescriptor(hashMap);
        }
        return immutableDescriptor;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected void cacheMBeanInfo(MBeanInfo mBeanInfo) {
        this.cachedMBeanInfo = mBeanInfo;
    }

    private boolean isMXBean() {
        return this.mbean.isMXBean();
    }

    private static <T> boolean identicalArrays(T[] TArray, T[] TArray2) {
        if (TArray == TArray2) {
            return true;
        }
        if (TArray == null || TArray2 == null || TArray.length != TArray2.length) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean equal(T t, T t2) {
        if (t == t2) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        return t.equals(t2);
    }

    private static MBeanParameterInfo customize(MBeanParameterInfo mBeanParameterInfo, String string, String string2) {
        if (StandardMBean.equal(string, mBeanParameterInfo.getName()) && StandardMBean.equal(string2, mBeanParameterInfo.getDescription())) {
            return mBeanParameterInfo;
        }
        if (mBeanParameterInfo instanceof OpenMBeanParameterInfo) {
            OpenMBeanParameterInfo openMBeanParameterInfo = (OpenMBeanParameterInfo)((Object)mBeanParameterInfo);
            return new OpenMBeanParameterInfoSupport(string, string2, openMBeanParameterInfo.getOpenType(), mBeanParameterInfo.getDescriptor());
        }
        return new MBeanParameterInfo(string, mBeanParameterInfo.getType(), string2, mBeanParameterInfo.getDescriptor());
    }

    private static MBeanConstructorInfo customize(MBeanConstructorInfo mBeanConstructorInfo, String string, MBeanParameterInfo[] mBeanParameterInfoArray) {
        if (StandardMBean.equal(string, mBeanConstructorInfo.getDescription()) && StandardMBean.identicalArrays(mBeanParameterInfoArray, mBeanConstructorInfo.getSignature())) {
            return mBeanConstructorInfo;
        }
        if (mBeanConstructorInfo instanceof OpenMBeanConstructorInfo) {
            OpenMBeanParameterInfo[] openMBeanParameterInfoArray = StandardMBean.paramsToOpenParams(mBeanParameterInfoArray);
            return new OpenMBeanConstructorInfoSupport(mBeanConstructorInfo.getName(), string, openMBeanParameterInfoArray, mBeanConstructorInfo.getDescriptor());
        }
        return new MBeanConstructorInfo(mBeanConstructorInfo.getName(), string, mBeanParameterInfoArray, mBeanConstructorInfo.getDescriptor());
    }

    private static MBeanOperationInfo customize(MBeanOperationInfo mBeanOperationInfo, String string, MBeanParameterInfo[] mBeanParameterInfoArray, int n) {
        if (StandardMBean.equal(string, mBeanOperationInfo.getDescription()) && StandardMBean.identicalArrays(mBeanParameterInfoArray, mBeanOperationInfo.getSignature()) && n == mBeanOperationInfo.getImpact()) {
            return mBeanOperationInfo;
        }
        if (mBeanOperationInfo instanceof OpenMBeanOperationInfo) {
            OpenMBeanOperationInfo openMBeanOperationInfo = (OpenMBeanOperationInfo)((Object)mBeanOperationInfo);
            OpenMBeanParameterInfo[] openMBeanParameterInfoArray = StandardMBean.paramsToOpenParams(mBeanParameterInfoArray);
            return new OpenMBeanOperationInfoSupport(mBeanOperationInfo.getName(), string, openMBeanParameterInfoArray, openMBeanOperationInfo.getReturnOpenType(), n, mBeanOperationInfo.getDescriptor());
        }
        return new MBeanOperationInfo(mBeanOperationInfo.getName(), string, mBeanParameterInfoArray, mBeanOperationInfo.getReturnType(), n, mBeanOperationInfo.getDescriptor());
    }

    private static MBeanAttributeInfo customize(MBeanAttributeInfo mBeanAttributeInfo, String string) {
        if (StandardMBean.equal(string, mBeanAttributeInfo.getDescription())) {
            return mBeanAttributeInfo;
        }
        if (mBeanAttributeInfo instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo openMBeanAttributeInfo = (OpenMBeanAttributeInfo)((Object)mBeanAttributeInfo);
            return new OpenMBeanAttributeInfoSupport(mBeanAttributeInfo.getName(), string, openMBeanAttributeInfo.getOpenType(), mBeanAttributeInfo.isReadable(), mBeanAttributeInfo.isWritable(), mBeanAttributeInfo.isIs(), mBeanAttributeInfo.getDescriptor());
        }
        return new MBeanAttributeInfo(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), string, mBeanAttributeInfo.isReadable(), mBeanAttributeInfo.isWritable(), mBeanAttributeInfo.isIs(), mBeanAttributeInfo.getDescriptor());
    }

    private static OpenMBeanParameterInfo[] paramsToOpenParams(MBeanParameterInfo[] mBeanParameterInfoArray) {
        if (mBeanParameterInfoArray instanceof OpenMBeanParameterInfo[]) {
            return (OpenMBeanParameterInfo[])mBeanParameterInfoArray;
        }
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray = new OpenMBeanParameterInfoSupport[mBeanParameterInfoArray.length];
        System.arraycopy(mBeanParameterInfoArray, 0, openMBeanParameterInfoArray, 0, mBeanParameterInfoArray.length);
        return openMBeanParameterInfoArray;
    }

    private MBeanConstructorInfo[] getConstructors(MBeanInfo mBeanInfo, Object object) {
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.getConstructors(mBeanInfo.getConstructors(), object);
        if (mBeanConstructorInfoArray == null) {
            return null;
        }
        int n = mBeanConstructorInfoArray.length;
        MBeanConstructorInfo[] mBeanConstructorInfoArray2 = new MBeanConstructorInfo[n];
        for (int i = 0; i < n; ++i) {
            MBeanParameterInfo[] mBeanParameterInfoArray;
            MBeanConstructorInfo mBeanConstructorInfo = mBeanConstructorInfoArray[i];
            MBeanParameterInfo[] mBeanParameterInfoArray2 = mBeanConstructorInfo.getSignature();
            if (mBeanParameterInfoArray2 != null) {
                int n2 = mBeanParameterInfoArray2.length;
                mBeanParameterInfoArray = new MBeanParameterInfo[n2];
                for (int j = 0; j < n2; ++j) {
                    MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray2[j];
                    mBeanParameterInfoArray[j] = StandardMBean.customize(mBeanParameterInfo, this.getParameterName(mBeanConstructorInfo, mBeanParameterInfo, j), this.getDescription(mBeanConstructorInfo, mBeanParameterInfo, j));
                }
            } else {
                mBeanParameterInfoArray = null;
            }
            mBeanConstructorInfoArray2[i] = StandardMBean.customize(mBeanConstructorInfo, this.getDescription(mBeanConstructorInfo), mBeanParameterInfoArray);
        }
        return mBeanConstructorInfoArray2;
    }

    private MBeanOperationInfo[] getOperations(MBeanInfo mBeanInfo) {
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        if (mBeanOperationInfoArray == null) {
            return null;
        }
        int n = mBeanOperationInfoArray.length;
        MBeanOperationInfo[] mBeanOperationInfoArray2 = new MBeanOperationInfo[n];
        for (int i = 0; i < n; ++i) {
            MBeanParameterInfo[] mBeanParameterInfoArray;
            MBeanOperationInfo mBeanOperationInfo = mBeanOperationInfoArray[i];
            MBeanParameterInfo[] mBeanParameterInfoArray2 = mBeanOperationInfo.getSignature();
            if (mBeanParameterInfoArray2 != null) {
                int n2 = mBeanParameterInfoArray2.length;
                mBeanParameterInfoArray = new MBeanParameterInfo[n2];
                for (int j = 0; j < n2; ++j) {
                    MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray2[j];
                    mBeanParameterInfoArray[j] = StandardMBean.customize(mBeanParameterInfo, this.getParameterName(mBeanOperationInfo, mBeanParameterInfo, j), this.getDescription(mBeanOperationInfo, mBeanParameterInfo, j));
                }
            } else {
                mBeanParameterInfoArray = null;
            }
            mBeanOperationInfoArray2[i] = StandardMBean.customize(mBeanOperationInfo, this.getDescription(mBeanOperationInfo), mBeanParameterInfoArray, this.getImpact(mBeanOperationInfo));
        }
        return mBeanOperationInfoArray2;
    }

    private MBeanAttributeInfo[] getAttributes(MBeanInfo mBeanInfo) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray == null) {
            return null;
        }
        int n = mBeanAttributeInfoArray.length;
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = new MBeanAttributeInfo[n];
        for (int i = 0; i < n; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
            mBeanAttributeInfoArray2[i] = StandardMBean.customize(mBeanAttributeInfo, this.getDescription(mBeanAttributeInfo));
        }
        return mBeanAttributeInfoArray2;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mbean.register(mBeanServer, objectName);
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            this.mbean.unregister();
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.mbean.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean immutableInfo(Class<? extends StandardMBean> clazz) {
        if (clazz == StandardMBean.class || clazz == StandardEmitterMBean.class) {
            return true;
        }
        Map<Class, Boolean> map = mbeanInfoSafeMap;
        synchronized (map) {
            Boolean bl = mbeanInfoSafeMap.get(clazz);
            if (bl == null) {
                try {
                    MBeanInfoSafeAction mBeanInfoSafeAction = new MBeanInfoSafeAction(clazz);
                    bl = AccessController.doPrivileged(mBeanInfoSafeAction);
                }
                catch (Exception exception) {
                    bl = false;
                }
                mbeanInfoSafeMap.put(clazz, bl);
            }
            return bl;
        }
    }

    static boolean overrides(Class<?> clazz, Class<?> clazz2, String string, Class<?> ... classArray) {
        for (Class<?> clazz3 = clazz; clazz3 != clazz2; clazz3 = clazz3.getSuperclass()) {
            try {
                clazz3.getDeclaredMethod(string, classArray);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return false;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 16);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 16, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        StandardMBean.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 16);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 16, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        StandardMBean.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (StandardMBean.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            StandardMBean.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            StandardMBean.debug(dbgTag, string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MBeanInfoSafeAction
    implements PrivilegedAction<Boolean> {
        private final Class subclass;

        MBeanInfoSafeAction(Class clazz) {
            this.subclass = clazz;
        }

        @Override
        public Boolean run() {
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "cacheMBeanInfo", MBeanInfo.class)) {
                return false;
            }
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "getCachedMBeanInfo", null)) {
                return false;
            }
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "getMBeanInfo", null)) {
                return false;
            }
            if (StandardEmitterMBean.class.isAssignableFrom(this.subclass) && StandardMBean.overrides(this.subclass, StandardEmitterMBean.class, "getNotificationInfo", null)) {
                return false;
            }
            return true;
        }
    }
}

