/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.Panel.UninstallationOngoing;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.InfoDir;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.PackageCollector;

public class UninstallationOngoingCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_UninstallationOngoing";

    public UninstallationOngoingCtrl() {
        super("UninstallationOngoing", new UninstallationOngoing());
    }

    public String getNext() {
        return new String("UninstallationCompleted");
    }

    public String getPrevious() {
        return new String("UninstallationImminent");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    public void beforeShow() {
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(false, 2);
        SetupFrame setupFrame2 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame2.setButtonEnabled(false, 1);
        SetupFrame setupFrame3 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame3.setButtonEnabled(false, 3);
        SetupFrame setupFrame4 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame4.setButtonSelected(4);
        UninstallationOngoing panel = (UninstallationOngoing)this.getPanel();
        this.getSetupFrame();
        panel.setStopButtonActionCommand("ActionStop");
        panel.addStopButtonActionListener(this.getSetupFrame().getSetupActionListener());
        InstallData data = InstallData.getInstance();
        Vector uninstallPackages = new Vector();
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        PackageCollector.collectUninstallPackages(packageData, uninstallPackages);
        Vector sortedPackages = new Vector();
        PackageCollector.sortPackages(uninstallPackages, sortedPackages, "uninstall");
        data.setInstallPackages(sortedPackages);
        Installer installer = InstallerFactory.getInstance();
        installer.preInstallationOngoing();
    }

    public void duringShow() {
        Thread t = new Thread(){
            UninstallationOngoing panel;
            InstallData installData;
            Vector uninstallPackages;
            {
                this.panel = (UninstallationOngoing)UninstallationOngoingCtrl.this.getPanel();
                this.installData = InstallData.getInstance();
                this.uninstallPackages = this.installData.getInstallPackages();
            }

            public void run() {
                LogManager.setCommandsHeaderLine("Uninstallation");
                Installer installer = InstallerFactory.getInstance();
                for (int i = 0; i < this.uninstallPackages.size(); ++i) {
                    PackageDescription packageData = (PackageDescription)this.uninstallPackages.get(i);
                    int progress = Math.round(100 * (i + 1) / this.uninstallPackages.size());
                    this.panel.setProgressValue(progress);
                    this.panel.setProgressText(packageData.getPackageName());
                    installer.uninstallPackage(packageData);
                    if (this.installData.isAbortedInstallation()) break;
                }
                if (this.installData.isAbortedInstallation()) {
                    LogManager.setCommandsHeaderLine("Uninstallation aborted!");
                }
                installer.postUninstallationOngoing();
                String next = UninstallationOngoingCtrl.this.getNext();
                UninstallationOngoingCtrl.this.getSetupFrame().setCurrentPanel(next, false, true);
            }
        };
        t.start();
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(true, 2);
        SetupFrame setupFrame2 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame2.setButtonEnabled(true, 1);
        SetupFrame setupFrame3 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame3.setButtonEnabled(true, 3);
        InstallData data = InstallData.getInstance();
        if (!data.isAbortedInstallation() && (data.isTypicalInstallation() || data.isMaskedCompleteUninstallation())) {
            InfoDir.removeUninstallationFiles();
        }
        return repeatDialog;
    }
}

