/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import com.sun.java.swing.Painter;
import com.sun.java.swing.plaf.nimbus.State;
import com.sun.java.swing.plaf.nimbus.SynthPainterImpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.AppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NimbusStyle
extends SynthStyle {
    public static final String LARGE_KEY = "large";
    public static final String SMALL_KEY = "small";
    public static final String MINI_KEY = "mini";
    public static final double LARGE_SCALE = 1.15;
    public static final double SMALL_SCALE = 0.857;
    public static final double MINI_SCALE = 0.714;
    private static final Object NULL = Character.valueOf('\u0000');
    private static final Color DEFAULT_COLOR = new ColorUIResource(Color.BLACK);
    private static final Comparator<RuntimeState> STATE_COMPARATOR = new Comparator<RuntimeState>(){

        @Override
        public int compare(RuntimeState runtimeState, RuntimeState runtimeState2) {
            return runtimeState.state - runtimeState2.state;
        }
    };
    private String prefix;
    private SynthPainter painter;
    private Values values;
    private CacheKey tmpKey = new CacheKey("", 0);
    private JComponent component;

    NimbusStyle(String string, JComponent jComponent) {
        this.component = jComponent;
        this.prefix = string;
        this.painter = new SynthPainterImpl(this);
    }

    @Override
    public void installDefaults(SynthContext synthContext) {
        this.validate();
        super.installDefaults(synthContext);
    }

    static String parsePrefix(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (c != '[' && c != '.' || bl) continue;
            return string.substring(0, i);
        }
        return null;
    }

    static void uninitialize() {
        AppContext appContext = AppContext.getAppContext();
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)appContext.get("NimbusStyle.defaults.pcl");
        if (propertyChangeListener != null) {
            UIManager.getDefaults().removePropertyChangeListener(propertyChangeListener);
            UIManager.getLookAndFeelDefaults().removePropertyChangeListener(propertyChangeListener);
        }
        appContext.put("NimbusStyle.defaults", null);
    }

    private void validate() {
        Object object;
        TreeMap<String, Object> treeMap;
        if (this.values != null) {
            return;
        }
        this.values = new Values();
        AppContext appContext = AppContext.getAppContext();
        HashMap<String, TreeMap<String, Object>> hashMap = (HashMap<String, TreeMap<String, Object>>)appContext.get("NimbusStyle.defaults");
        if (hashMap == null) {
            hashMap = new HashMap<String, TreeMap<String, Object>>();
            this.compileDefaults(hashMap, UIManager.getDefaults());
            treeMap = UIManager.getLookAndFeelDefaults();
            this.compileDefaults(hashMap, (UIDefaults)((Object)treeMap));
            object = (PropertyChangeListener)appContext.get("NimbusStyle.defaults.pcl");
            if (object == null) {
                object = new DefaultsListener();
                UIManager.getDefaults().addPropertyChangeListener((PropertyChangeListener)object);
                UIManager.getLookAndFeelDefaults().addPropertyChangeListener((PropertyChangeListener)object);
                appContext.put("NimbusStyle.defaults.pcl", object);
            }
            appContext.put("NimbusStyle.defaults", hashMap);
        }
        treeMap = (TreeMap)hashMap.get(this.prefix);
        if (this.component != null && (object = this.component.getClientProperty("Nimbus.Overrides")) instanceof UIDefaults) {
            Object object2 = this.component.getClientProperty("Nimbus.Overrides.InheritDefaults");
            boolean bl = object2 instanceof Boolean ? (Boolean)object2 : true;
            UIDefaults uIDefaults = (UIDefaults)object;
            TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
            for (Object k : uIDefaults.keySet()) {
                String string;
                if (!(k instanceof String) || !(string = (String)k).startsWith(this.prefix)) continue;
                treeMap2.put(string, uIDefaults.get(string));
            }
            if (bl) {
                treeMap.putAll(treeMap2);
            } else {
                treeMap = treeMap2;
            }
        }
        this.init(this.values, treeMap);
    }

    private void compileDefaults(Map<String, TreeMap<String, Object>> map, UIDefaults uIDefaults) {
        for (Map.Entry entry : uIDefaults.entrySet()) {
            String string;
            String string2;
            if (!(entry.getKey() instanceof String) || (string2 = NimbusStyle.parsePrefix(string = (String)entry.getKey())) == null) continue;
            TreeMap<String, Object> treeMap = map.get(string2);
            if (treeMap == null) {
                treeMap = new TreeMap();
                map.put(string2, treeMap);
            }
            treeMap.put(string, entry.getValue());
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void init(Values values, TreeMap<String, Object> treeMap) {
        Object object3;
        Object object2;
        ArrayList<State> arrayList = new ArrayList<State>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        String string = (String)treeMap.get(this.prefix + ".States");
        if (string != null) {
            int n;
            String[] stringArray = string.split(",");
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].trim();
                if (!State.isStandardStateName(stringArray[n])) {
                    object2 = this.prefix + "." + (String)stringArray[n];
                    object3 = (State)treeMap.get(object2);
                    if (object3 == null) continue;
                    arrayList.add((State)object3);
                    continue;
                }
                arrayList.add(State.getStandardState(stringArray[n]));
            }
            if (arrayList.size() > 0) {
                values.stateTypes = arrayList.toArray(new State[arrayList.size()]);
            }
            n = 1;
            for (Object object3 : arrayList) {
                hashMap.put(((State)object3).getName(), n);
                n <<= 1;
            }
        } else {
            arrayList.add(State.Enabled);
            arrayList.add(State.MouseOver);
            arrayList.add(State.Pressed);
            arrayList.add(State.Disabled);
            arrayList.add(State.Focused);
            arrayList.add(State.Selected);
            arrayList.add(State.Default);
            hashMap.put("Enabled", 1);
            hashMap.put("MouseOver", 2);
            hashMap.put("Pressed", 4);
            hashMap.put("Disabled", 8);
            hashMap.put("Focused", 256);
            hashMap.put("Selected", 512);
            hashMap.put("Default", 1024);
        }
        for (String string2 : treeMap.keySet()) {
            String[] stringArray;
            object2 = string2.substring(this.prefix.length());
            if (((String)object2).indexOf(34) != -1 || ((String)object2).indexOf(58) != -1) continue;
            object2 = ((String)object2).substring(1);
            object3 = null;
            Object object4 = null;
            int n = ((String)object2).indexOf(93);
            if (n < 0) {
                object4 = object2;
            } else {
                object3 = ((String)object2).substring(0, n);
                object4 = ((String)object2).substring(n + 2);
            }
            if (object3 == null) {
                if ("contentMargins".equals(object4)) {
                    values.contentMargins = (Insets)treeMap.get(string2);
                    continue;
                }
                if ("States".equals(object4)) continue;
                values.defaults.put(object4, treeMap.get(string2));
                continue;
            }
            boolean bl = false;
            int n2 = 0;
            for (String string3 : stringArray = ((String)object3).split("\\+")) {
                if (hashMap.containsKey(string3)) {
                    n2 |= ((Integer)hashMap.get(string3)).intValue();
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            Object object5 = null;
            for (RuntimeState runtimeState : arrayList2) {
                if (runtimeState.state != n2) continue;
                object5 = runtimeState;
                break;
            }
            if (object5 == null) {
                object5 = new RuntimeState(n2, (String)object3);
                arrayList2.add((String[])object5);
            }
            if ("backgroundPainter".equals(object4)) {
                object5.backgroundPainter = this.getPainter(treeMap, string2);
                continue;
            }
            if ("foregroundPainter".equals(object4)) {
                object5.foregroundPainter = this.getPainter(treeMap, string2);
                continue;
            }
            if ("borderPainter".equals(object4)) {
                object5.borderPainter = this.getPainter(treeMap, string2);
                continue;
            }
            object5.defaults.put(object4, treeMap.get(string2));
        }
        Collections.sort(arrayList2, STATE_COMPARATOR);
        values.states = arrayList2.toArray(new RuntimeState[arrayList2.size()]);
    }

    private Painter getPainter(TreeMap<String, Object> treeMap, String string) {
        Object object = treeMap.get(string);
        if (object instanceof UIDefaults.LazyValue) {
            object = ((UIDefaults.LazyValue)object).createValue(UIManager.getDefaults());
        }
        return object instanceof Painter ? (Painter)object : null;
    }

    @Override
    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Values values = this.getValues(synthContext);
        if (values.contentMargins == null) {
            insets.right = 0;
            insets.left = 0;
            insets.top = 0;
            insets.bottom = 0;
            return insets;
        }
        insets.bottom = values.contentMargins.bottom;
        insets.top = values.contentMargins.top;
        insets.left = values.contentMargins.left;
        insets.right = values.contentMargins.right;
        String string = (String)synthContext.getComponent().getClientProperty("JComponent.sizeVariant");
        if (string != null) {
            if (LARGE_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 1.15);
                insets.top = (int)((double)insets.top * 1.15);
                insets.left = (int)((double)insets.left * 1.15);
                insets.right = (int)((double)insets.right * 1.15);
            } else if (SMALL_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 0.857);
                insets.top = (int)((double)insets.top * 0.857);
                insets.left = (int)((double)insets.left * 0.857);
                insets.right = (int)((double)insets.right * 0.857);
            } else if (MINI_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 0.714);
                insets.top = (int)((double)insets.top * 0.714);
                insets.left = (int)((double)insets.left * 0.714);
                insets.right = (int)((double)insets.right * 0.714);
            }
        }
        return insets;
    }

    @Override
    protected Color getColorForState(SynthContext synthContext, ColorType colorType) {
        String string = null;
        if (colorType == ColorType.BACKGROUND) {
            string = "background";
        } else if (colorType == ColorType.FOREGROUND) {
            string = "textForeground";
        } else if (colorType == ColorType.TEXT_BACKGROUND) {
            string = "textBackground";
        } else if (colorType == ColorType.TEXT_FOREGROUND) {
            string = "textForeground";
        } else if (colorType == ColorType.FOCUS) {
            string = "focus";
        } else if (colorType != null) {
            string = colorType.toString();
        } else {
            return DEFAULT_COLOR;
        }
        Color color = (Color)this.get(synthContext, string);
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        return color;
    }

    @Override
    protected Font getFontForState(SynthContext synthContext) {
        String string;
        Font font = (Font)this.get(synthContext, "font");
        if (font == null) {
            font = UIManager.getFont("defaultFont");
        }
        if ((string = (String)synthContext.getComponent().getClientProperty("JComponent.sizeVariant")) != null) {
            if (LARGE_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 1.15));
            } else if (SMALL_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 0.857));
            } else if (MINI_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 0.714));
            }
        }
        return font;
    }

    @Override
    public SynthPainter getPainter(SynthContext synthContext) {
        return this.painter;
    }

    @Override
    public boolean isOpaque(SynthContext synthContext) {
        if ("Table.cellRenderer".equals(synthContext.getComponent().getName())) {
            return true;
        }
        Boolean bl = (Boolean)this.get(synthContext, "opaque");
        return bl == null ? false : bl;
    }

    @Override
    public Object get(SynthContext synthContext, Object object) {
        boolean bl;
        Values values = this.getValues(synthContext);
        String string = object.toString();
        String string2 = string.substring(string.indexOf(".") + 1);
        Object object2 = null;
        int n = this.getExtendedState(synthContext, values);
        this.tmpKey.init(string2, n);
        object2 = values.cache.get(this.tmpKey);
        boolean bl2 = bl = object2 != null;
        if (!bl) {
            RuntimeState runtimeState = null;
            int[] nArray = new int[]{-1};
            while (object2 == null && (runtimeState = this.getNextState(values.states, nArray, n)) != null) {
                object2 = runtimeState.defaults.get(string2);
            }
            if (object2 == null && values.defaults != null) {
                object2 = values.defaults.get(string2);
            }
            if (object2 == null) {
                object2 = UIManager.get(string);
            }
            if (object2 == null && string2.equals("focusInputMap")) {
                object2 = super.get(synthContext, string);
            }
            values.cache.put(new CacheKey(string2, n), object2 == null ? NULL : object2);
        }
        return object2 == NULL ? null : object2;
    }

    public Painter getBackgroundPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("backgroundPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.backgroundPainter == null) continue;
            painter = runtimeState.backgroundPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "backgroundPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("backgroundPainter$$instance", n), painter);
        }
        return painter;
    }

    public Painter getForegroundPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("foregroundPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.foregroundPainter == null) continue;
            painter = runtimeState.foregroundPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "foregroundPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("foregroundPainter$$instance", n), painter);
        }
        return painter;
    }

    public Painter getBorderPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("borderPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.borderPainter == null) continue;
            painter = runtimeState.borderPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "borderPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("borderPainter$$instance", n), painter);
        }
        return painter;
    }

    private Values getValues(SynthContext synthContext) {
        this.validate();
        return this.values;
    }

    private boolean contains(String[] stringArray, String string) {
        assert (string != null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private int getExtendedState(SynthContext synthContext, Values values) {
        JComponent jComponent = synthContext.getComponent();
        int n = 0;
        int n2 = 1;
        Object object = jComponent.getClientProperty("Nimbus.State");
        if (object != null) {
            String string = object.toString();
            String[] stringArray = string.split("\\+");
            if (values.stateTypes == null) {
                for (String string2 : stringArray) {
                    State.StandardState standardState = State.getStandardState(string2);
                    if (standardState == null) continue;
                    n |= standardState.getState();
                }
            } else {
                for (State state : values.stateTypes) {
                    if (this.contains(stringArray, state.getName())) {
                        n |= n2;
                    }
                    n2 <<= 1;
                }
            }
        } else {
            if (values.stateTypes == null) {
                return synthContext.getComponentState();
            }
            int n3 = synthContext.getComponentState();
            for (State state : values.stateTypes) {
                if (state.isInState(jComponent, n3)) {
                    n |= n2;
                }
                n2 <<= 1;
            }
        }
        return n;
    }

    private RuntimeState getNextState(RuntimeState[] runtimeStateArray, int[] nArray, int n) {
        if (runtimeStateArray != null && runtimeStateArray.length > 0) {
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            if (n == 0) {
                for (int i = runtimeStateArray.length - 1; i >= 0; --i) {
                    if (runtimeStateArray[i].state != 0) continue;
                    nArray[0] = i;
                    return runtimeStateArray[i];
                }
                nArray[0] = -1;
                return null;
            }
            int n5 = nArray == null || nArray[0] == -1 ? runtimeStateArray.length : nArray[0];
            for (int i = n5 - 1; i >= 0; --i) {
                int n6 = runtimeStateArray[i].state;
                if (n6 == 0) {
                    if (n4 != -1) continue;
                    n4 = i;
                    continue;
                }
                if ((n & n6) != n6) continue;
                int n7 = n6;
                n7 -= (0xAAAAAAAA & n7) >>> 1;
                n7 = (n7 & 0x33333333) + (n7 >>> 2 & 0x33333333);
                n7 = n7 + (n7 >>> 4) & 0xF0F0F0F;
                n7 += n7 >>> 8;
                n7 += n7 >>> 16;
                if ((n7 &= 0xFF) <= n2) continue;
                n3 = i;
                n2 = n7;
            }
            if (n3 != -1) {
                nArray[0] = n3;
                return runtimeStateArray[n3];
            }
            if (n4 != -1) {
                nArray[0] = n4;
                return runtimeStateArray[n4];
            }
        }
        nArray[0] = -1;
        return null;
    }

    private static final class CacheKey {
        private String key;
        private int xstate;

        CacheKey(Object object, int n) {
            this.init(object, n);
        }

        void init(Object object, int n) {
            this.key = object.toString();
            this.xstate = n;
        }

        public boolean equals(Object object) {
            CacheKey cacheKey = (CacheKey)object;
            if (object == null) {
                return false;
            }
            if (this.xstate != cacheKey.xstate) {
                return false;
            }
            return this.key.equals(cacheKey.key);
        }

        public int hashCode() {
            int n = 3;
            n = 29 * n + this.key.hashCode();
            n = 29 * n + this.xstate;
            return n;
        }
    }

    private static final class DefaultsListener
    implements PropertyChangeListener {
        private DefaultsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AppContext.getAppContext().put("NimbusStyle.defaults", null);
        }
    }

    private final class RuntimeState
    implements Cloneable {
        int state;
        Painter backgroundPainter;
        Painter foregroundPainter;
        Painter borderPainter;
        String stateName;
        UIDefaults defaults = new UIDefaults(10, 0.7f);

        private RuntimeState(int n, String string) {
            this.state = n;
            this.stateName = string;
        }

        public String toString() {
            return this.stateName;
        }

        public RuntimeState clone() {
            RuntimeState runtimeState = new RuntimeState(this.state, this.stateName);
            runtimeState.backgroundPainter = this.backgroundPainter;
            runtimeState.foregroundPainter = this.foregroundPainter;
            runtimeState.borderPainter = this.borderPainter;
            runtimeState.defaults.putAll(this.defaults);
            return runtimeState;
        }
    }

    private static final class Values {
        State[] stateTypes = null;
        RuntimeState[] states = null;
        Insets contentMargins;
        UIDefaults defaults = new UIDefaults(10, 0.7f);
        Map<CacheKey, Object> cache = new HashMap<CacheKey, Object>();

        private Values() {
        }
    }
}

