/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;

public abstract class OffScreenSurfaceManager
extends CachingSurfaceManager {
    private WeakReference<SurfaceData> bisdRef;

    public OffScreenSurfaceManager(Component component, BufferedImage bufferedImage) {
        super(bufferedImage);
        GraphicsConfiguration graphicsConfiguration;
        if (!accelerationEnabled) {
            return;
        }
        ComponentPeer componentPeer = null;
        if (component != null) {
            componentPeer = component.getPeer();
        }
        if (componentPeer != null) {
            graphicsConfiguration = componentPeer.getGraphicsConfiguration();
        } else {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        }
        this.initAcceleratedSurface(graphicsConfiguration, this.bImg.getWidth(), this.bImg.getHeight());
        if (this.sdAccel != null) {
            this.sdDefault = this.sdAccel;
        }
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        if (accelerationEnabled && surfaceData != this.sdAccel && this.isDestSurfaceAccelerated(surfaceData)) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.sdAccel != null) {
                return this.sdAccel;
            }
        }
        return this.sdDefault;
    }

    protected synchronized void copyDefaultToAccelerated() {
        if (this.accelSurfaces != null) {
            boolean bl = false;
            Collection collection = this.accelSurfaces.values();
            SurfaceData surfaceData = this.bisdRef == null ? null : (SurfaceData)this.bisdRef.get();
            for (SurfaceData surfaceData2 : collection) {
                if (this.sdDefault == null || this.sdDefault == surfaceData2) continue;
                try {
                    Object object;
                    if (surfaceData == null) {
                        object = this.createTempImage();
                        surfaceData = BufImgSurfaceData.createData((BufferedImage)object);
                        this.bisdRef = new WeakReference<SurfaceData>(surfaceData);
                    }
                    object = this.sdDefault.getSurfaceType();
                    SurfaceType surfaceType = surfaceData.getSurfaceType();
                    SurfaceType surfaceType2 = surfaceData2.getSurfaceType();
                    Blit blit = Blit.getFromCache((SurfaceType)object, CompositeType.SrcNoEa, surfaceType);
                    blit.Blit(this.sdDefault, surfaceData, AlphaComposite.Src, null, 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                    blit = Blit.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
                    blit.Blit(surfaceData, surfaceData2, AlphaComposite.Src, null, 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                }
                catch (Exception exception) {
                    if (surfaceData2 != null) {
                        surfaceData2.setSurfaceLost(true);
                    }
                    bl = true;
                }
            }
            if (!bl) {
                this.sdDefault.setNeedsBackup(false);
            }
        }
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        return true;
    }

    public synchronized void flush() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            HashMap hashMap = this.accelSurfaces;
            this.accelSurfaces = new HashMap(2);
            this.accelSurfaces.put(this.sdDefault.getDeviceConfiguration(), this.sdDefault);
            Collection collection = hashMap.values();
            for (SurfaceData surfaceData : collection) {
                if (surfaceData == this.sdDefault) continue;
                surfaceData.flush();
            }
        }
    }

    public synchronized void invalidateAcceleratedSurfaces() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            HashMap hashMap = this.accelSurfaces;
            this.accelSurfaces = new HashMap(2);
            this.accelSurfaces.put(this.sdDefault.getDeviceConfiguration(), this.sdDefault);
            Collection collection = hashMap.values();
            for (SurfaceData surfaceData : collection) {
                if (surfaceData == this.sdDefault) continue;
                surfaceData.invalidate();
            }
        }
    }

    protected BufferedImage createTempImage() {
        ColorModel colorModel = this.bImg.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(this.bImg.getWidth(), this.bImg.getHeight());
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }
}

