/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import sun.util.calendar.AbstractCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;

public abstract class BaseCalendar
extends AbstractCalendar {
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    private static final int BASE_YEAR = 1970;
    private static final int[] FIXED_DATES = new int[]{719163, 719528, 719893, 720259, 720624, 720989, 721354, 721720, 722085, 722450, 722815, 723181, 723546, 723911, 724276, 724642, 725007, 725372, 725737, 726103, 726468, 726833, 727198, 727564, 727929, 728294, 728659, 729025, 729390, 729755, 730120, 730486, 730851, 731216, 731581, 731947, 732312, 732677, 733042, 733408, 733773, 734138, 734503, 734869, 735234, 735599, 735964, 736330, 736695, 737060, 737425, 737791, 738156, 738521, 738886, 739252, 739617, 739982, 740347, 740713, 741078, 741443, 741808, 742174, 742539, 742904, 743269, 743635, 744000, 744365};
    static final int[] DAYS_IN_MONTH = new int[]{31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] ACCUMULATED_DAYS_IN_MONTH = new int[]{-30, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] ACCUMULATED_DAYS_IN_MONTH_LEAP = new int[]{-30, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    public boolean validate(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        if (date.isNormalized()) {
            return true;
        }
        int n = date.getMonth();
        if (n < 1 || n > 12) {
            return false;
        }
        int n2 = date.getDayOfMonth();
        if (n2 <= 0 || n2 > this.getMonthLength(date.getNormalizedYear(), n)) {
            return false;
        }
        int n3 = date.getDayOfWeek();
        if (n3 != Integer.MIN_VALUE && n3 != this.getDayOfWeek(date)) {
            return false;
        }
        if (!this.validateTime(calendarDate)) {
            return false;
        }
        date.setNormalized(true);
        return true;
    }

    public boolean normalize(CalendarDate calendarDate) {
        if (calendarDate.isNormalized()) {
            return true;
        }
        Date date = (Date)calendarDate;
        TimeZone timeZone = date.getZone();
        if (timeZone != null) {
            this.getTime(calendarDate);
            return true;
        }
        int n = this.normalizeTime(date);
        this.normalizeMonth(date);
        long l = (long)date.getDayOfMonth() + (long)n;
        int n2 = date.getMonth();
        int n3 = date.getNormalizedYear();
        int n4 = this.getMonthLength(n3, n2);
        if (l <= 0L || l > (long)n4) {
            if (l <= 0L && l > -28L) {
                n4 = this.getMonthLength(n3, --n2);
                date.setDayOfMonth((int)(l += (long)n4));
                if (n2 == 0) {
                    n2 = 12;
                    date.setNormalizedYear(n3 - 1);
                }
                date.setMonth(n2);
            } else if (l > (long)n4 && l < (long)(n4 + 28)) {
                date.setDayOfMonth((int)(l -= (long)n4));
                if (++n2 > 12) {
                    date.setNormalizedYear(n3 + 1);
                    n2 = 1;
                }
                date.setMonth(n2);
            } else {
                long l2 = l + this.getFixedDate(n3, n2, 1, date) - 1L;
                this.getCalendarDateFromFixedDate(date, l2);
            }
        } else {
            date.setDayOfWeek(this.getDayOfWeek(date));
        }
        calendarDate.setLeapYear(this.isLeapYear(date.getNormalizedYear()));
        calendarDate.setZoneOffset(0);
        calendarDate.setDaylightSaving(0);
        date.setNormalized(true);
        return true;
    }

    void normalizeMonth(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        int n = date.getNormalizedYear();
        long l = date.getMonth();
        if (l <= 0L) {
            long l2 = 1L - l;
            l = 13L - l2 % 12L;
            date.setNormalizedYear(n -= (int)(l2 / 12L + 1L));
            date.setMonth((int)l);
        } else if (l > 12L) {
            n += (int)((l - 1L) / 12L);
            l = (l - 1L) % 12L + 1L;
            date.setNormalizedYear(n);
            date.setMonth((int)l);
        }
    }

    public int getYearLength(CalendarDate calendarDate) {
        return this.isLeapYear(((Date)calendarDate).getNormalizedYear()) ? 366 : 365;
    }

    public int getYearLengthInMonths(CalendarDate calendarDate) {
        return 12;
    }

    public int getMonthLength(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        int n = date.getMonth();
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Illegal month value: " + n);
        }
        return this.getMonthLength(date.getNormalizedYear(), n);
    }

    private final int getMonthLength(int n, int n2) {
        int n3 = DAYS_IN_MONTH[n2];
        if (n2 == 2 && this.isLeapYear(n)) {
            ++n3;
        }
        return n3;
    }

    public long getDayOfYear(CalendarDate calendarDate) {
        return this.getDayOfYear(((Date)calendarDate).getNormalizedYear(), calendarDate.getMonth(), calendarDate.getDayOfMonth());
    }

    final long getDayOfYear(int n, int n2, int n3) {
        return (long)n3 + (long)(this.isLeapYear(n) ? ACCUMULATED_DAYS_IN_MONTH_LEAP[n2] : ACCUMULATED_DAYS_IN_MONTH[n2]);
    }

    public long getFixedDate(CalendarDate calendarDate) {
        if (!calendarDate.isNormalized()) {
            this.normalizeMonth(calendarDate);
        }
        return this.getFixedDate(((Date)calendarDate).getNormalizedYear(), calendarDate.getMonth(), calendarDate.getDayOfMonth(), (Date)calendarDate);
    }

    public long getFixedDate(int n, int n2, int n3, Date date) {
        boolean bl;
        boolean bl2 = bl = n2 == 1 && n3 == 1;
        if (date != null && date.hit(n)) {
            if (bl) {
                return date.getCachedJan1();
            }
            return date.getCachedJan1() + this.getDayOfYear(n, n2, n3) - 1L;
        }
        int n4 = n - 1970;
        if (n4 >= 0 && n4 < FIXED_DATES.length) {
            long l = FIXED_DATES[n4];
            if (date != null) {
                date.setCache(n, l, this.isLeapYear(n) ? 366 : 365);
            }
            return bl ? l : l + this.getDayOfYear(n, n2, n3) - 1L;
        }
        long l = (long)n - 1L;
        long l2 = n3;
        l2 = l >= 0L ? (l2 += 365L * l + l / 4L - l / 100L + l / 400L + (long)((367 * n2 - 362) / 12)) : (l2 += 365L * l + CalendarUtils.floorDivide(l, 4L) - CalendarUtils.floorDivide(l, 100L) + CalendarUtils.floorDivide(l, 400L) + (long)CalendarUtils.floorDivide(367 * n2 - 362, 12));
        if (n2 > 2) {
            l2 -= this.isLeapYear(n) ? 1L : 2L;
        }
        if (date != null && bl) {
            date.setCache(n, l2, this.isLeapYear(n) ? 366 : 365);
        }
        return l2;
    }

    public void getCalendarDateFromFixedDate(CalendarDate calendarDate, long l) {
        int n;
        boolean bl;
        long l2;
        int n2;
        Date date = (Date)calendarDate;
        if (date.hit(l)) {
            n2 = date.getCachedYear();
            l2 = date.getCachedJan1();
            bl = this.isLeapYear(n2);
        } else {
            n2 = this.getGregorianYearFromFixedDate(l);
            l2 = this.getFixedDate(n2, 1, 1, null);
            bl = this.isLeapYear(n2);
            date.setCache(n2, l2, bl ? 366 : 365);
        }
        int n3 = (int)(l - l2);
        long l3 = l2 + 31L + 28L;
        if (bl) {
            ++l3;
        }
        if (l >= l3) {
            n3 += bl ? 1 : 2;
        }
        n = (n = 12 * n3 + 373) > 0 ? (n /= 367) : CalendarUtils.floorDivide(n, 367);
        long l4 = l2 + (long)ACCUMULATED_DAYS_IN_MONTH[n];
        if (bl && n >= 3) {
            ++l4;
        }
        int n4 = (int)(l - l4) + 1;
        int n5 = BaseCalendar.getDayOfWeekFromFixedDate(l);
        assert (n5 > 0) : "negative day of week " + n5;
        date.setNormalizedYear(n2);
        date.setMonth(n);
        date.setDayOfMonth(n4);
        date.setDayOfWeek(n5);
        date.setLeapYear(bl);
        date.setNormalized(true);
    }

    public int getDayOfWeek(CalendarDate calendarDate) {
        long l = this.getFixedDate(calendarDate);
        return BaseCalendar.getDayOfWeekFromFixedDate(l);
    }

    public static final int getDayOfWeekFromFixedDate(long l) {
        if (l >= 0L) {
            return (int)(l % 7L) + 1;
        }
        return (int)CalendarUtils.mod(l, 7L) + 1;
    }

    public int getYearFromFixedDate(long l) {
        return this.getGregorianYearFromFixedDate(l);
    }

    final int getGregorianYearFromFixedDate(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        if (l > 0L) {
            long l2 = l - 1L;
            n4 = (int)(l2 / 146097L);
            int n5 = (int)(l2 % 146097L);
            n3 = n5 / 36524;
            int n6 = n5 % 36524;
            n2 = n6 / 1461;
            int n7 = n6 % 1461;
            n = n7 / 365;
            int n8 = n7 % 365 + 1;
        } else {
            long l3 = l - 1L;
            n4 = (int)CalendarUtils.floorDivide(l3, 146097L);
            int n9 = (int)CalendarUtils.mod(l3, 146097L);
            n3 = CalendarUtils.floorDivide(n9, 36524);
            int n10 = CalendarUtils.mod(n9, 36524);
            n2 = CalendarUtils.floorDivide(n10, 1461);
            int n11 = CalendarUtils.mod(n10, 1461);
            n = CalendarUtils.floorDivide(n11, 365);
            int n12 = CalendarUtils.mod(n11, 365) + 1;
        }
        int n13 = 400 * n4 + 100 * n3 + 4 * n2 + n;
        if (n3 != 4 && n != 4) {
            ++n13;
        }
        return n13;
    }

    protected boolean isLeapYear(CalendarDate calendarDate) {
        return this.isLeapYear(((Date)calendarDate).getNormalizedYear());
    }

    boolean isLeapYear(int n) {
        return CalendarUtils.isGregorianLeapYear(n);
    }

    public static abstract class Date
    extends CalendarDate {
        int cachedYear = 2004;
        long cachedFixedDateJan1 = 731581L;
        long cachedFixedDateNextJan1 = this.cachedFixedDateJan1 + 366L;

        protected Date() {
        }

        protected Date(TimeZone timeZone) {
            super(timeZone);
        }

        public Date setNormalizedDate(int n, int n2, int n3) {
            this.setNormalizedYear(n);
            this.setMonth(n2).setDayOfMonth(n3);
            return this;
        }

        public abstract int getNormalizedYear();

        public abstract void setNormalizedYear(int var1);

        protected final boolean hit(int n) {
            return n == this.cachedYear;
        }

        protected final boolean hit(long l) {
            return l >= this.cachedFixedDateJan1 && l < this.cachedFixedDateNextJan1;
        }

        protected int getCachedYear() {
            return this.cachedYear;
        }

        protected long getCachedJan1() {
            return this.cachedFixedDateJan1;
        }

        protected void setCache(int n, long l, int n2) {
            this.cachedYear = n;
            this.cachedFixedDateJan1 = l;
            this.cachedFixedDateNextJan1 = l + (long)n2;
        }
    }
}

