/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;

public class SnmpCounter64
extends SnmpValue {
    static final String name = "Counter64";
    private long value = 0L;

    public SnmpCounter64(long l) throws IllegalArgumentException {
        if (l < 0L || l > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.value = l;
    }

    public SnmpCounter64(Long l) throws IllegalArgumentException {
        this((long)l);
    }

    public long longValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            return new SnmpOid(lArray[n]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw new SnmpStatusException(2);
        }
        return n + 1;
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        if (snmpOid.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        snmpOid2.append(snmpOid);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public final synchronized Object clone() {
        SnmpCounter64 snmpCounter64 = null;
        try {
            snmpCounter64 = (SnmpCounter64)super.clone();
            snmpCounter64.value = this.value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpCounter64;
    }

    public final String getTypeName() {
        return name;
    }
}

