/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.net.MalformedURLException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PolicySpi;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import sun.security.provider.PolicyFile;

public final class PolicySpiFile
extends PolicySpi {
    private PolicyFile pf;

    public PolicySpiFile(Policy.Parameters parameters) {
        if (parameters == null) {
            this.pf = new PolicyFile();
        } else {
            if (!(parameters instanceof URIParameter)) {
                throw new IllegalArgumentException("Unrecognized policy parameter: " + parameters);
            }
            URIParameter uRIParameter = (URIParameter)parameters;
            try {
                this.pf = new PolicyFile(uRIParameter.getURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Invalid URIParameter", malformedURLException);
            }
        }
    }

    protected PermissionCollection engineGetPermissions(CodeSource codeSource) {
        return this.pf.getPermissions(codeSource);
    }

    protected PermissionCollection engineGetPermissions(ProtectionDomain protectionDomain) {
        return this.pf.getPermissions(protectionDomain);
    }

    protected boolean engineImplies(ProtectionDomain protectionDomain, Permission permission) {
        return this.pf.implies(protectionDomain, permission);
    }

    protected void engineRefresh() {
        this.pf.refresh();
    }
}

