/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteComponentRaster;
import sun.print.PSPrinterJob;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void fill(Shape shape, Color color) {
        this.deviceFill(shape.getPathIterator(new AffineTransform()), color);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, f, f2, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    protected boolean canDrawStringToWidth() {
        return true;
    }

    protected int platformFontCount(Font font, String string) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        return pSPrinterJob.platformFontCount(font, string);
    }

    protected void drawString(String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        PSPrinterJob pSPrinterJob;
        boolean bl;
        AffineTransform affineTransform;
        int n;
        if (string.length() == 0) {
            return;
        }
        if (font.hasLayoutAttributes() && !this.printingGlyphVector) {
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            textLayout.draw(this, f, f2);
            return;
        }
        Font font2 = this.getFont();
        if (!font2.equals(font)) {
            this.setFont(font);
        } else {
            font2 = null;
        }
        boolean bl2 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl3 = this.getFont().isTransformed();
        if (bl3 && (n = (affineTransform = this.getFont().getTransform()).getType()) == 1) {
            f4 = (float)affineTransform.getTranslateX();
            f5 = (float)affineTransform.getTranslateY();
            if ((double)Math.abs(f4) < 1.0E-5) {
                f4 = 0.0f;
            }
            if ((double)Math.abs(f5) < 1.0E-5) {
                f5 = 0.0f;
            }
            bl3 = false;
        }
        boolean bl4 = bl = !bl3;
        if (!PSPrinterJob.shapeTextProp && bl && (pSPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                pSPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException classCastException) {
                if (font2 != null) {
                    this.setFont(font2);
                }
                throw new IllegalArgumentException("Expected a Color instance");
            }
            pSPrinterJob.setTransform(this.getTransform());
            pSPrinterJob.setClip(this.getClip());
            bl2 = pSPrinterJob.textOut(this, string, f + f4, f2 + f5, font, fontRenderContext, f3);
        }
        if (!bl2) {
            if (font2 != null) {
                this.setFont(font2);
                font2 = null;
            }
            super.drawString(string, f, f2, font, fontRenderContext, f3);
        }
        if (font2 != null) {
            this.setFont(font2);
        }
    }

    protected boolean drawImageToPlatform(Image image, AffineTransform affineTransform, Color color, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        BufferedImage bufferedImage = this.getBufferedImage(image);
        if (bufferedImage == null) {
            return true;
        }
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        double d3 = pSPrinterJob.getXRes();
        double d4 = pSPrinterJob.getYRes();
        double d5 = d3 / 72.0;
        double d6 = d4 / 72.0;
        int n5 = affineTransform2.getType();
        boolean bl3 = bl2 = (n5 & 0x30) != 0;
        if (bl2) {
            if (d > d5) {
                d = d5;
            }
            if (d2 > d6) {
                d2 = d6;
            }
        }
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n6 = (int)rectangle2D.getWidth();
            int n7 = (int)rectangle2D.getHeight();
            if (n6 > 0 && n7 > 0) {
                boolean bl4 = true;
                if (!bl && this.hasTransparentPixels(bufferedImage)) {
                    bl4 = false;
                    if (this.isBitmaskTransparency(bufferedImage)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(bufferedImage, affineTransform, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl4 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl4 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > bufferedImage.getWidth(null) || n2 + n4 > bufferedImage.getHeight(null)) && this.canDoRedraws()) {
                    bl4 = false;
                }
                if (!bl4) {
                    int n8;
                    affineTransform2.getMatrix(dArray);
                    AffineTransform affineTransform4 = new AffineTransform(dArray[0] / d5, dArray[1] / d6, dArray[2] / d5, dArray[3] / d6, dArray[4] / d5, dArray[5] / d6);
                    Rectangle2D.Float float_5 = new Rectangle2D.Float(n, n2, n3, n4);
                    Shape shape2 = affineTransform2.createTransformedShape(float_5);
                    Rectangle2D rectangle2D2 = shape2.getBounds2D();
                    rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + 0.001, rectangle2D2.getHeight() + 0.001);
                    int n9 = (int)rectangle2D2.getWidth();
                    int n10 = (int)rectangle2D2.getHeight();
                    int n11 = n9 * n10 * 3;
                    int n12 = 0x800000;
                    double d7 = d3 < d4 ? d3 : d4;
                    double d8 = 1.0;
                    for (n8 = (int)d7; n11 > n12 && n8 > 72; n8 /= 2, n11 /= 4) {
                        d8 *= 2.0;
                    }
                    if (n8 < 72) {
                        d8 = d7 / 72.0;
                    }
                    rectangle2D2.setRect(rectangle2D2.getX() / d8, rectangle2D2.getY() / d8, rectangle2D2.getWidth() / d8, rectangle2D2.getHeight() / d8);
                    pSPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D2, d8, d8);
                    return true;
                }
                BufferedImage bufferedImage2 = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(bufferedImage, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                Shape shape3 = this.getClip();
                Shape shape4 = this.getTransform().createTransformedShape(shape3);
                AffineTransform affineTransform5 = AffineTransform.getScaleInstance(d, d2);
                Shape shape5 = affineTransform5.createTransformedShape(shape);
                Area area = new Area(shape5);
                Area area2 = new Area(shape4);
                area.intersect(area2);
                pSPrinterJob.setClip(area);
                Rectangle2D.Float float_6 = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage2.getRaster();
                pSPrinterJob.drawImageBGR(byteComponentRaster.getDataStorage(), float_6.x, float_6.y, (float)Math.rint((double)float_6.width + 0.5), (float)Math.rint((double)float_6.height + 0.5), 0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getWidth(), bufferedImage2.getHeight());
                pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape3));
                graphics2D.dispose();
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Shape shape, AffineTransform affineTransform) throws PrinterException {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, pSPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(pSPrinterJob.getXRes() / d);
        float f2 = (float)(pSPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-pSPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / pSPrinterJob.getXRes() * 72.0, -pSPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / pSPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        pSPrinterJob.setClip(affineTransform.createTransformedShape(shape));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        pSPrinterJob.drawImageBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.deviceFill(pathIterator, color, this.getTransform(), this.getClip());
    }

    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceClip(PathIterator pathIterator) {
    }
}

