/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.graph;

import com.sun.corba.se.impl.orbutil.graph.Graph;
import com.sun.corba.se.impl.orbutil.graph.Node;
import com.sun.corba.se.impl.orbutil.graph.NodeData;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphImpl
extends AbstractSet
implements Graph {
    private Map nodeToData = new HashMap();

    public GraphImpl() {
    }

    public GraphImpl(Collection collection) {
        this();
        this.addAll(collection);
    }

    public boolean add(Object object) {
        if (!(object instanceof Node)) {
            throw new IllegalArgumentException("Graphs must contain only Node instances");
        }
        Node node = (Node)object;
        boolean bl = this.nodeToData.keySet().contains(object);
        if (!bl) {
            NodeData nodeData = new NodeData();
            this.nodeToData.put(node, nodeData);
        }
        return !bl;
    }

    public Iterator iterator() {
        return this.nodeToData.keySet().iterator();
    }

    public int size() {
        return this.nodeToData.keySet().size();
    }

    public NodeData getNodeData(Node node) {
        return (NodeData)this.nodeToData.get(node);
    }

    private void clearNodeData() {
        for (Map.Entry entry : this.nodeToData.entrySet()) {
            NodeData nodeData = (NodeData)entry.getValue();
            nodeData.clear();
        }
    }

    void visitAll(NodeVisitor nodeVisitor) {
        boolean bl = false;
        do {
            bl = true;
            Map.Entry[] entryArray = this.nodeToData.entrySet().toArray(new Map.Entry[0]);
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                Node node = (Node)entry.getKey();
                NodeData nodeData = (NodeData)entry.getValue();
                if (nodeData.isVisited()) continue;
                nodeData.visited();
                bl = false;
                nodeVisitor.visit(this, node, nodeData);
            }
        } while (!bl);
    }

    private void markNonRoots() {
        this.visitAll(new NodeVisitor(){

            public void visit(Graph graph, Node node, NodeData nodeData) {
                for (Node node2 : node.getChildren()) {
                    graph.add(node2);
                    NodeData nodeData2 = graph.getNodeData(node2);
                    nodeData2.notRoot();
                }
            }
        });
    }

    private Set collectRootSet() {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Map.Entry entry : this.nodeToData.entrySet()) {
            Node node = (Node)entry.getKey();
            NodeData nodeData = (NodeData)entry.getValue();
            if (!nodeData.isRoot()) continue;
            hashSet.add(node);
        }
        return hashSet;
    }

    public Set getRoots() {
        this.clearNodeData();
        this.markNonRoots();
        return this.collectRootSet();
    }

    static interface NodeVisitor {
        public void visit(Graph var1, Node var2, NodeData var3);
    }
}

