/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

class GenericBeanInfo
extends SimpleBeanInfo {
    private BeanDescriptor beanDescriptor;
    private EventSetDescriptor[] events;
    private int defaultEvent;
    private PropertyDescriptor[] properties;
    private int defaultProperty;
    private MethodDescriptor[] methods;
    private final Reference<BeanInfo> targetBeanInfoRef;

    public GenericBeanInfo(BeanDescriptor beanDescriptor, EventSetDescriptor[] eventSetDescriptorArray, int n, PropertyDescriptor[] propertyDescriptorArray, int n2, MethodDescriptor[] methodDescriptorArray, BeanInfo beanInfo) {
        this.beanDescriptor = beanDescriptor;
        this.events = eventSetDescriptorArray;
        this.defaultEvent = n;
        this.properties = propertyDescriptorArray;
        this.defaultProperty = n2;
        this.methods = methodDescriptorArray;
        this.targetBeanInfoRef = new SoftReference<BeanInfo>(beanInfo);
    }

    GenericBeanInfo(GenericBeanInfo genericBeanInfo) {
        int n;
        int n2;
        this.beanDescriptor = new BeanDescriptor(genericBeanInfo.beanDescriptor);
        if (genericBeanInfo.events != null) {
            n2 = genericBeanInfo.events.length;
            this.events = new EventSetDescriptor[n2];
            for (n = 0; n < n2; ++n) {
                this.events[n] = new EventSetDescriptor(genericBeanInfo.events[n]);
            }
        }
        this.defaultEvent = genericBeanInfo.defaultEvent;
        if (genericBeanInfo.properties != null) {
            n2 = genericBeanInfo.properties.length;
            this.properties = new PropertyDescriptor[n2];
            for (n = 0; n < n2; ++n) {
                PropertyDescriptor propertyDescriptor = genericBeanInfo.properties[n];
                this.properties[n] = propertyDescriptor instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)propertyDescriptor) : new PropertyDescriptor(propertyDescriptor);
            }
        }
        this.defaultProperty = genericBeanInfo.defaultProperty;
        if (genericBeanInfo.methods != null) {
            n2 = genericBeanInfo.methods.length;
            this.methods = new MethodDescriptor[n2];
            for (n = 0; n < n2; ++n) {
                this.methods[n] = new MethodDescriptor(genericBeanInfo.methods[n]);
            }
        }
        this.targetBeanInfoRef = genericBeanInfo.targetBeanInfoRef;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    public int getDefaultPropertyIndex() {
        return this.defaultProperty;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    public int getDefaultEventIndex() {
        return this.defaultEvent;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public Image getIcon(int n) {
        BeanInfo beanInfo = this.targetBeanInfoRef.get();
        if (beanInfo != null) {
            return beanInfo.getIcon(n);
        }
        return super.getIcon(n);
    }
}

