/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.UCharacterProperty;

public final class UTF16 {
    public static final int CODEPOINT_MIN_VALUE = 0;
    public static final int CODEPOINT_MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static final int LEAD_SURROGATE_MAX_VALUE = 56319;
    public static final int TRAIL_SURROGATE_MAX_VALUE = 57343;
    public static final int SURROGATE_MIN_VALUE = 55296;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    public static int charAt(String string, int n) {
        char c;
        if (n < 0 || n >= string.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        char c2 = string.charAt(n);
        if (c2 < '\ud800' || c2 > '\udfff') {
            return c2;
        }
        if (c2 <= '\udbff') {
            char c3;
            if (string.length() != ++n && (c3 = string.charAt(n)) >= '\udc00' && c3 <= '\udfff') {
                return UCharacterProperty.getRawSupplementary(c2, c3);
            }
        } else if (--n >= 0 && (c = string.charAt(n)) >= '\ud800' && c <= '\udbff') {
            return UCharacterProperty.getRawSupplementary(c, c2);
        }
        return c2;
    }

    public static int charAt(char[] cArray, int n, int n2, int n3) {
        if ((n3 += n) < n || n3 >= n2) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        char c = cArray[n3];
        if (!UTF16.isSurrogate(c)) {
            return c;
        }
        if (c <= '\udbff') {
            if (++n3 >= n2) {
                return c;
            }
            char c2 = cArray[n3];
            if (UTF16.isTrailSurrogate(c2)) {
                return UCharacterProperty.getRawSupplementary(c, c2);
            }
        } else {
            char c3;
            if (n3 == n) {
                return c;
            }
            if (UTF16.isLeadSurrogate(c3 = cArray[--n3])) {
                return UCharacterProperty.getRawSupplementary(c3, c);
            }
        }
        return c;
    }

    public static int getCharCount(int n) {
        if (n < 65536) {
            return 1;
        }
        return 2;
    }

    public static boolean isSurrogate(char c) {
        return '\ud800' <= c && c <= '\udfff';
    }

    public static boolean isTrailSurrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    public static boolean isLeadSurrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    public static char getLeadSurrogate(int n) {
        if (n >= 65536) {
            return (char)(55232 + (n >> 10));
        }
        return '\u0000';
    }

    public static char getTrailSurrogate(int n) {
        if (n >= 65536) {
            return (char)(56320 + (n & 0x3FF));
        }
        return (char)n;
    }

    public static String valueOf(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        return UTF16.toString(n);
    }

    public static StringBuffer append(StringBuffer stringBuffer, int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint: " + Integer.toHexString(n));
        }
        if (n >= 65536) {
            stringBuffer.append(UTF16.getLeadSurrogate(n));
            stringBuffer.append(UTF16.getTrailSurrogate(n));
        } else {
            stringBuffer.append((char)n);
        }
        return stringBuffer;
    }

    public static int moveCodePointOffset(char[] cArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = cArray.length;
        int n7 = n3 + n;
        if (n < 0 || n2 < n) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > n6) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n7 > n2) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n4 > 0) {
            if (n4 + n7 > n6) {
                throw new StringIndexOutOfBoundsException(n7);
            }
            for (n5 = n4; n7 < n2 && n5 > 0; --n5, ++n7) {
                char c = cArray[n7];
                if (!UTF16.isLeadSurrogate(c) || n7 + 1 >= n2 || !UTF16.isTrailSurrogate(cArray[n7 + 1])) continue;
                ++n7;
            }
        } else {
            if (n7 + n4 < n) {
                throw new StringIndexOutOfBoundsException(n7);
            }
            for (n5 = -n4; n5 > 0 && --n7 >= n; --n5) {
                char c = cArray[n7];
                if (!UTF16.isTrailSurrogate(c) || n7 <= n || !UTF16.isLeadSurrogate(cArray[n7 - 1])) continue;
                --n7;
            }
        }
        if (n5 != 0) {
            throw new StringIndexOutOfBoundsException(n4);
        }
        return n7 -= n;
    }

    private static String toString(int n) {
        if (n < 65536) {
            return String.valueOf((char)n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UTF16.getLeadSurrogate(n));
        stringBuffer.append(UTF16.getTrailSurrogate(n));
        return stringBuffer.toString();
    }
}

