/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;

class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");
    private List certPathCheckers;

    PKIXMasterCertPathValidator(List list) {
        this.certPathCheckers = list;
    }

    void validate(CertPath certPath, List list) throws CertPathValidatorException {
        X509Certificate x509Certificate = null;
        PKIXCertPathChecker pKIXCertPathChecker = null;
        int n = list.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Set set;
            if (debug != null) {
                debug.println("Checking cert" + (i + 1) + " ...");
            }
            if ((set = (x509Certificate = (X509Certificate)list.get(i)).getCriticalExtensionOIDs()) == null) {
                set = Collections.EMPTY_SET;
            }
            if (debug != null && !set.isEmpty()) {
                debug.println("Set of critical extensions:");
                object = set.iterator();
                while (object.hasNext()) {
                    debug.println((String)object.next());
                }
            }
            object = null;
            for (int j = 0; j < this.certPathCheckers.size(); ++j) {
                block19: {
                    pKIXCertPathChecker = (PKIXCertPathChecker)this.certPathCheckers.get(j);
                    if (debug != null) {
                        debug.println("-Using checker" + (j + 1) + " ... [" + pKIXCertPathChecker.getClass().getName() + "]");
                    }
                    if (i == 0) {
                        pKIXCertPathChecker.init(false);
                    }
                    try {
                        pKIXCertPathChecker.check(x509Certificate, set);
                        if (this.isRevocationCheck(pKIXCertPathChecker, j, this.certPathCheckers)) {
                            if (debug != null) {
                                debug.println("-checker" + (j + 1) + " validation succeeded");
                            }
                            ++j;
                            continue;
                        }
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        if (object != null && pKIXCertPathChecker instanceof CrlRevocationChecker) {
                            throw object;
                        }
                        CertPathValidatorException certPathValidatorException2 = new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n - (i + 1));
                        if (certPathValidatorException instanceof CertificateRevokedException) {
                            throw certPathValidatorException2;
                        }
                        if (!this.isRevocationCheck(pKIXCertPathChecker, j, this.certPathCheckers)) {
                            throw certPathValidatorException2;
                        }
                        object = certPathValidatorException2;
                        if (debug == null) break block19;
                        debug.println(certPathValidatorException.getMessage());
                        debug.println("preparing to failover (from OCSP to CRLs)");
                    }
                }
                if (debug == null) continue;
                debug.println("-checker" + (j + 1) + " validation succeeded");
            }
            if (debug != null) {
                debug.println("checking for unresolvedCritExts");
            }
            if (!set.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, certPath, n - (i + 1));
            }
            if (debug == null) continue;
            debug.println("\ncert" + (i + 1) + " validation succeeded.\n");
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }

    private boolean isRevocationCheck(PKIXCertPathChecker pKIXCertPathChecker, int n, List list) {
        Object e;
        return pKIXCertPathChecker instanceof OCSPChecker && n + 1 < list.size() && (e = list.get(n + 1)) instanceof CrlRevocationChecker;
    }
}

