/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutorService
implements ExecutorService {
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new FutureTask<T>(runnable, t);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> runnableFuture = this.newTaskFor(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(runnable, t);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doInvokeAny(Collection<? extends Callable<T>> collection, boolean bl, long l) throws InterruptedException, ExecutionException, TimeoutException {
        if (collection == null) {
            throw new NullPointerException();
        }
        int n = collection.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList arrayList = new ArrayList(n);
        ExecutorCompletionService<T> executorCompletionService = new ExecutorCompletionService<T>(this);
        try {
            ExecutionException executionException = null;
            long l2 = bl ? System.nanoTime() : 0L;
            Iterator<Callable<T>> iterator = collection.iterator();
            arrayList.add(executorCompletionService.submit(iterator.next()));
            --n;
            int n2 = 1;
            while (true) {
                Object v;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n > 0) {
                        --n;
                        arrayList.add(executorCompletionService.submit(iterator.next()));
                        ++n2;
                    } else {
                        if (n2 == 0) {
                            if (executionException != null) throw executionException;
                            break;
                        }
                        if (bl) {
                            future = executorCompletionService.poll(l, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l3 = System.nanoTime();
                            l -= l3 - l2;
                            l2 = l3;
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n2;
                try {
                    v = future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                Object var17_17 = null;
                for (Future future2 : arrayList) {
                    future2.cancel(true);
                }
                return (T)v;
                break;
            }
            executionException = new ExecutionException();
            throw executionException;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Iterator iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Future future = (Future)iterator.next();
                future.cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        ArrayList<RunnableFuture<T>> arrayList;
        block11: {
            if (collection == null) {
                throw new NullPointerException();
            }
            ArrayList<RunnableFuture<T>> arrayList2 = new ArrayList<RunnableFuture<T>>(collection.size());
            boolean bl = false;
            try {
                for (Callable<T> object : collection) {
                    RunnableFuture<T> executionException = this.newTaskFor(object);
                    arrayList2.add(executionException);
                    this.execute(executionException);
                }
                for (Future future : arrayList2) {
                    if (future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {}
                }
                bl = true;
                arrayList = arrayList2;
                Object var8_11 = null;
                if (bl) break block11;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (!bl) {
                    for (Future future : arrayList2) {
                        future.cancel(true);
                    }
                }
                throw throwable;
            }
            for (Future future : arrayList2) {
                future.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        ArrayList<Future<T>> arrayList;
        boolean bl;
        ArrayList<Future<T>> arrayList2;
        block21: {
            ArrayList<Future<T>> arrayList3;
            block20: {
                Iterator iterator;
                ArrayList<Future<T>> arrayList4;
                block19: {
                    if (collection == null || timeUnit == null) {
                        throw new NullPointerException();
                    }
                    long l2 = timeUnit.toNanos(l);
                    arrayList2 = new ArrayList<Future<T>>(collection.size());
                    bl = false;
                    try {
                        for (Callable<T> callable : collection) {
                            arrayList2.add(this.newTaskFor(callable));
                        }
                        long l3 = System.nanoTime();
                        Iterator iterator2 = arrayList2.iterator();
                        while (iterator2.hasNext()) {
                            this.execute((Runnable)iterator2.next());
                            long l4 = System.nanoTime();
                            if ((l2 -= l4 - (l3 = l4)) > 0L) continue;
                            arrayList4 = arrayList2;
                            Object var17_19 = null;
                            if (bl) return arrayList4;
                            iterator = arrayList2.iterator();
                            break block19;
                        }
                        for (Future future : arrayList2) {
                            if (future.isDone()) continue;
                            if (l2 <= 0L) {
                                arrayList3 = arrayList2;
                                break block20;
                            }
                            try {
                                future.get(l2, TimeUnit.NANOSECONDS);
                            }
                            catch (CancellationException cancellationException) {
                            }
                            catch (ExecutionException executionException) {
                            }
                            catch (TimeoutException timeoutException) {
                                ArrayList<Future<T>> arrayList5 = arrayList2;
                                Object var17_21 = null;
                                if (bl) return arrayList5;
                                Iterator iterator3 = arrayList2.iterator();
                                while (true) {
                                    if (!iterator3.hasNext()) {
                                        return arrayList5;
                                    }
                                    Future future2 = (Future)iterator3.next();
                                    future2.cancel(true);
                                }
                            }
                            long l5 = System.nanoTime();
                            l2 -= l5 - l3;
                            l3 = l5;
                        }
                        bl = true;
                        arrayList = arrayList2;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var17_23 = null;
                        if (!bl) {
                            for (Future future : arrayList2) {
                                future.cancel(true);
                            }
                        }
                        throw throwable;
                    }
                }
                while (iterator.hasNext()) {
                    Future future = (Future)iterator.next();
                    future.cancel(true);
                }
                return arrayList4;
            }
            Object var17_20 = null;
            if (bl) return arrayList3;
            for (Future future : arrayList2) {
                future.cancel(true);
            }
            return arrayList3;
        }
        Object var17_22 = null;
        if (bl) return arrayList;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            future.cancel(true);
        }
        return arrayList;
    }
}

