/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.params;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.transforms.TransformParam;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath2FilterContainer
extends ElementProxy
implements TransformParam {
    private static final String _ATT_FILTER = "Filter";
    private static final String _ATT_FILTER_VALUE_INTERSECT = "intersect";
    private static final String _ATT_FILTER_VALUE_SUBTRACT = "subtract";
    private static final String _ATT_FILTER_VALUE_UNION = "union";
    public static final String INTERSECT = "intersect";
    public static final String SUBTRACT = "subtract";
    public static final String UNION = "union";
    public static final String _TAG_XPATH2 = "XPath";
    public static final String XPathFilter2NS = "http://www.w3.org/2002/06/xmldsig-filter2";

    private XPath2FilterContainer() {
    }

    private XPath2FilterContainer(Document document, String string, String string2) {
        super(document);
        this._constructionElement.setAttributeNS(null, _ATT_FILTER, string2);
        this._constructionElement.appendChild(document.createTextNode(string));
    }

    private XPath2FilterContainer(Element element, String string) throws XMLSecurityException {
        super(element, string);
        String string2 = this._constructionElement.getAttributeNS(null, _ATT_FILTER);
        if (!(string2.equals("intersect") || string2.equals("subtract") || string2.equals("union"))) {
            Object[] objectArray = new Object[]{_ATT_FILTER, string2, "intersect, subtract or union"};
            throw new XMLSecurityException("attributeValueIllegal", objectArray);
        }
    }

    public static XPath2FilterContainer newInstanceIntersect(Document document, String string) {
        return new XPath2FilterContainer(document, string, "intersect");
    }

    public static XPath2FilterContainer newInstanceSubtract(Document document, String string) {
        return new XPath2FilterContainer(document, string, "subtract");
    }

    public static XPath2FilterContainer newInstanceUnion(Document document, String string) {
        return new XPath2FilterContainer(document, string, "union");
    }

    public static NodeList newInstances(Document document, String[][] stringArray) {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(document.createTextNode("\n"));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            if (!(string.equals("intersect") || string.equals("subtract") || string.equals("union"))) {
                throw new IllegalArgumentException("The type(" + i + ")=\"" + string + "\" is illegal");
            }
            XPath2FilterContainer xPath2FilterContainer = new XPath2FilterContainer(document, string2, string);
            helperNodeList.appendChild(xPath2FilterContainer.getElement());
            helperNodeList.appendChild(document.createTextNode("\n"));
        }
        return helperNodeList;
    }

    public static XPath2FilterContainer newInstance(Element element, String string) throws XMLSecurityException {
        return new XPath2FilterContainer(element, string);
    }

    public boolean isIntersect() {
        return this._constructionElement.getAttributeNS(null, _ATT_FILTER).equals("intersect");
    }

    public boolean isSubtract() {
        return this._constructionElement.getAttributeNS(null, _ATT_FILTER).equals("subtract");
    }

    public boolean isUnion() {
        return this._constructionElement.getAttributeNS(null, _ATT_FILTER).equals("union");
    }

    public String getXPathFilterStr() {
        return this.getTextFromTextChild();
    }

    public Node getXPathFilterTextNode() {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public final String getBaseLocalName() {
        return _TAG_XPATH2;
    }

    public final String getBaseNamespace() {
        return XPathFilter2NS;
    }
}

