/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html.HTMLDocument;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.exception.PluginNotSupportedException;

public abstract class Node
implements org.w3c.dom.Node {
    protected DOMObject obj;
    private Document doc;

    protected Node(DOMObject dOMObject, Document document) {
        this.obj = dOMObject;
        this.doc = document;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        return this.obj.equals(((Node)object).obj);
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(this.toString());
        return stringBuffer.toString().hashCode();
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return super.toString();
    }

    public DOMObject getDOMObject() {
        return this.obj;
    }

    public String getNodeName() {
        return (String)this.obj.getMember("nodeName");
    }

    public abstract String getNodeValue() throws DOMException;

    public abstract void setNodeValue(String var1) throws DOMException;

    public short getNodeType() {
        return ((Number)this.obj.getMember("nodeType")).shortValue();
    }

    public NodeList getChildNodes() {
        return DOMObjectFactory.createNodeList(this.obj.getMember("childNodes"), (HTMLDocument)this.getOwnerDocument());
    }

    public org.w3c.dom.Node getParentNode() {
        return DOMObjectFactory.createNode(this.obj.getMember("parentNode"), this.getOwnerDocument());
    }

    public org.w3c.dom.Node getFirstChild() {
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    public org.w3c.dom.Node getLastChild() {
        int n;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null && (n = nodeList.getLength()) > 0) {
            return nodeList.item(n - 1);
        }
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return DOMObjectFactory.createNode(this.obj.getMember("previousSibling"), this.getOwnerDocument());
    }

    public org.w3c.dom.Node getNextSibling() {
        return DOMObjectFactory.createNode(this.obj.getMember("nextSibling"), (HTMLDocument)this.getOwnerDocument());
    }

    public NamedNodeMap getAttributes() {
        return DOMObjectFactory.createNamedNodeMap(this.obj.getMember("attributes"), (HTMLDocument)this.getOwnerDocument());
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node != null && node2 != null) {
            if (node instanceof Node && node2 instanceof Node) {
                Node node3 = (Node)node;
                Node node4 = (Node)node2;
                Object object = this.obj.call("insertBefore", new Object[]{node3.obj.getJSObject(), node4.obj.getJSObject()});
                return DOMObjectFactory.createNode(object, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.insertBefore() does not support node type: (" + node.getClass().getName() + ", " + node2.getClass().getName() + ")");
        }
        return null;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node != null && node2 != null) {
            if (node instanceof Node && node2 instanceof Node) {
                Node node3 = (Node)node;
                Node node4 = (Node)node2;
                Object object = this.obj.call("replaceChild", new Object[]{node3.obj.getJSObject(), node4.obj.getJSObject()});
                return DOMObjectFactory.createNode(object, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.replaceChild() does not support node type: (" + node.getClass().getName() + ", " + node2.getClass().getName() + ")");
        }
        return null;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        if (node != null) {
            if (node instanceof Node) {
                Node node2 = (Node)node;
                Object object = this.obj.call("removeChild", new Object[]{node2.obj.getJSObject()});
                return DOMObjectFactory.createNode(object, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.removeChild() does not support node type: " + node.getClass().getName());
        }
        return null;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        if (node != null) {
            if (node instanceof Node) {
                Node node2 = (Node)node;
                Object object = this.obj.call("appendChild", new Object[]{node2.obj.getJSObject()});
                return DOMObjectFactory.createNode(object, (HTMLDocument)this.getOwnerDocument());
            }
            throw new PluginNotSupportedException("Node.appendChild() does not support node type: " + node.getClass().getName());
        }
        return null;
    }

    public boolean hasChildNodes() {
        return (Boolean)this.obj.call("hasChildNodes", null);
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        Object object = this.obj.call("cloneNode", new Object[]{new Boolean(bl)});
        return DOMObjectFactory.createNode(object, (HTMLDocument)this.getOwnerDocument());
    }

    public void normalize() {
        this.obj.call("normalize", null);
    }

    public boolean isSupported(String string, String string2) {
        return this.getOwnerDocument().getImplementation().hasFeature(string, string2);
    }

    public String getNamespaceURI() {
        return (String)this.obj.getMember("namespaceURI");
    }

    public String getPrefix() {
        return (String)this.obj.getMember("prefix");
    }

    public void setPrefix(String string) throws DOMException {
        this.obj.setMember("prefix", string);
    }

    public String getLocalName() {
        return (String)this.obj.getMember("localName");
    }

    public boolean hasAttributes() {
        return (Boolean)this.obj.call("hasAttributes", null);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw new PluginNotSupportedException("Node.setUserData() is not supported.");
    }

    public Object getUserData(String string) {
        throw new PluginNotSupportedException("Node.getUserData() is not supported.");
    }

    public Object getFeature(String string, String string2) {
        throw new PluginNotSupportedException("Node.getFeature() is not supported.");
    }

    public boolean isSameNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isSameNode() is not supported.");
    }

    public boolean isEqualNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isEqualNode() is not supported.");
    }

    public String lookupNamespaceURI(String string) {
        throw new PluginNotSupportedException("Node.lookupNamespaceURI() is not supported.");
    }

    public boolean isDefaultNamespace(String string) {
        throw new PluginNotSupportedException("Node.isDefaultNamespace() is not supported.");
    }

    public String lookupPrefix(String string) {
        throw new PluginNotSupportedException("Node.lookupPrefix() is not supported.");
    }

    public String getTextContent() throws DOMException {
        throw new PluginNotSupportedException("Node.getTextContent() is not supported.");
    }

    public void setTextContent(String string) throws DOMException {
        throw new PluginNotSupportedException("Node.setTextContent() is not supported.");
    }

    public short compareDocumentPosition(org.w3c.dom.Node node) throws DOMException {
        throw new PluginNotSupportedException("Node.compareDocumentPosition() is not supported.");
    }

    public String getBaseURI() {
        throw new PluginNotSupportedException("Node.getBaseURI() is not supported.");
    }
}

