/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethodContext;

class CompositionAreaHandler
implements InputMethodListener,
InputMethodRequests {
    private static CompositionArea compositionArea;
    private static Object compositionAreaLock;
    private static CompositionAreaHandler compositionAreaOwner;
    private AttributedCharacterIterator composedText;
    private TextHitInfo caret = null;
    private Component clientComponent = null;
    private InputMethodContext inputMethodContext;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES;
    private static final AttributedCharacterIterator EMPTY_TEXT;

    CompositionAreaHandler(InputMethodContext inputMethodContext) {
        this.inputMethodContext = inputMethodContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCompositionArea() {
        Object object = compositionAreaLock;
        synchronized (object) {
            InputMethodRequests inputMethodRequests;
            compositionArea = new CompositionArea();
            if (compositionAreaOwner != null) {
                compositionArea.setHandlerInfo(compositionAreaOwner, this.inputMethodContext);
            }
            if (this.clientComponent != null && (inputMethodRequests = this.clientComponent.getInputMethodRequests()) != null && this.inputMethodContext.useBelowTheSpotInput()) {
                this.setCompositionAreaUndecorated(true);
            }
        }
    }

    void setClientComponent(Component component) {
        this.clientComponent = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grabCompositionArea(boolean bl) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner != this) {
                compositionAreaOwner = this;
                if (compositionArea != null) {
                    compositionArea.setHandlerInfo(this, this.inputMethodContext);
                }
                if (bl) {
                    if (this.composedText != null && compositionArea == null) {
                        this.createCompositionArea();
                    }
                    if (compositionArea != null) {
                        compositionArea.setText(this.composedText, this.caret);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCompositionArea() {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this) {
                compositionAreaOwner = null;
                if (compositionArea != null) {
                    compositionArea.setHandlerInfo(null, null);
                    compositionArea.setText(null, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeCompositionArea() {
        if (compositionArea != null) {
            Object object = compositionAreaLock;
            synchronized (object) {
                compositionAreaOwner = null;
                compositionArea.setHandlerInfo(null, null);
                compositionArea.setText(null, null);
            }
        }
    }

    boolean isCompositionAreaVisible() {
        if (compositionArea != null) {
            return compositionArea.isCompositionAreaVisible();
        }
        return false;
    }

    void setCompositionAreaVisible(boolean bl) {
        if (compositionArea != null) {
            compositionArea.setCompositionAreaVisible(bl);
        }
    }

    void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (inputMethodEvent.getID() == 1100) {
            this.inputMethodTextChanged(inputMethodEvent);
        } else {
            this.caretPositionChanged(inputMethodEvent);
        }
    }

    void setCompositionAreaUndecorated(boolean bl) {
        if (compositionArea != null) {
            compositionArea.setCompositionAreaUndecorated(bl);
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n = inputMethodEvent.getCommittedCharacterCount();
        this.composedText = null;
        this.caret = null;
        if (attributedCharacterIterator != null && n < attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()) {
            if (compositionArea == null) {
                this.createCompositionArea();
            }
            AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n, attributedCharacterIterator.getEndIndex(), IM_ATTRIBUTES);
            attributedString.addAttribute(TextAttribute.FONT, compositionArea.getFont());
            this.composedText = attributedString.getIterator();
            this.caret = inputMethodEvent.getCaret();
        }
        if (compositionArea != null) {
            compositionArea.setText(this.composedText, this.caret);
        }
        if (n > 0) {
            this.inputMethodContext.dispatchCommittedText((Component)inputMethodEvent.getSource(), attributedCharacterIterator, n);
            if (this.isCompositionAreaVisible()) {
                compositionArea.updateWindowLocation();
            }
        }
        inputMethodEvent.consume();
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        if (compositionArea != null) {
            compositionArea.setCaret(inputMethodEvent.getCaret());
        }
        inputMethodEvent.consume();
    }

    InputMethodRequests getClientInputMethodRequests() {
        if (this.clientComponent != null) {
            return this.clientComponent.getInputMethodRequests();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                return compositionArea.getTextLocation(textHitInfo);
            }
            if (this.composedText != null) {
                return new Rectangle(0, 0, 0, 10);
            }
            InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getTextLocation(textHitInfo);
            }
            return new Rectangle(0, 0, 0, 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextHitInfo getLocationOffset(int n, int n2) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                return compositionArea.getLocationOffset(n, n2);
            }
            return null;
        }
    }

    public int getInsertPositionOffset() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getInsertPositionOffset();
        }
        return 0;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedText(n, n2, attributeArray);
        }
        return EMPTY_TEXT;
    }

    public int getCommittedTextLength() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedTextLength();
        }
        return 0;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.cancelLatestCommittedText(attributeArray);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getSelectedText(attributeArray);
        }
        return EMPTY_TEXT;
    }

    static {
        compositionAreaLock = new Object();
        IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
        EMPTY_TEXT = new AttributedString("").getIterator();
    }
}

