/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.Debug;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintsChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final int certPathLength;
    private int maxPathLength;
    private int i;
    private NameConstraintsExtension prevNC;
    private static Set<String> supportedExts;

    ConstraintsChecker(int n) throws CertPathValidatorException {
        this.certPathLength = n;
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.i = 0;
        this.maxPathLength = this.certPathLength;
        this.prevNC = null;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        if (supportedExts == null) {
            supportedExts = new HashSet<String>();
            supportedExts.add(PKIXExtensions.BasicConstraints_Id.toString());
            supportedExts.add(PKIXExtensions.NameConstraints_Id.toString());
            supportedExts = Collections.unmodifiableSet(supportedExts);
        }
        return supportedExts;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        ++this.i;
        this.checkBasicConstraints(x509Certificate);
        this.verifyNameConstraints(x509Certificate);
        if (collection != null && !collection.isEmpty()) {
            collection.remove(PKIXExtensions.BasicConstraints_Id.toString());
            collection.remove(PKIXExtensions.NameConstraints_Id.toString());
        }
    }

    private void verifyNameConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        String string = "name constraints";
        if (debug != null) {
            debug.println("---checking " + string + "...");
        }
        if (!(this.prevNC == null || this.i != this.certPathLength && X509CertImpl.isSelfIssued(x509Certificate))) {
            if (debug != null) {
                debug.println("prevNC = " + this.prevNC);
                debug.println("currDN = " + x509Certificate.getSubjectX500Principal());
            }
            try {
                if (!this.prevNC.verify(x509Certificate)) {
                    throw new CertPathValidatorException(string + " check failed");
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException(iOException);
            }
        }
        this.prevNC = ConstraintsChecker.mergeNameConstraints(x509Certificate, this.prevNC);
        if (debug != null) {
            debug.println(string + " verified.");
        }
    }

    static NameConstraintsExtension mergeNameConstraints(X509Certificate x509Certificate, NameConstraintsExtension nameConstraintsExtension) throws CertPathValidatorException {
        X509CertImpl x509CertImpl;
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        NameConstraintsExtension nameConstraintsExtension2 = x509CertImpl.getNameConstraintsExtension();
        if (debug != null) {
            debug.println("prevNC = " + nameConstraintsExtension);
            debug.println("newNC = " + String.valueOf(nameConstraintsExtension2));
        }
        if (nameConstraintsExtension == null) {
            if (debug != null) {
                debug.println("mergedNC = " + String.valueOf(nameConstraintsExtension2));
            }
            if (nameConstraintsExtension2 == null) {
                return nameConstraintsExtension2;
            }
            return (NameConstraintsExtension)nameConstraintsExtension2.clone();
        }
        try {
            nameConstraintsExtension.merge(nameConstraintsExtension2);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        if (debug != null) {
            debug.println("mergedNC = " + nameConstraintsExtension);
        }
        return nameConstraintsExtension;
    }

    private void checkBasicConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        String string = "basic constraints";
        if (debug != null) {
            debug.println("---checking " + string + "...");
            debug.println("i = " + this.i);
            debug.println("maxPathLength = " + this.maxPathLength);
        }
        if (this.i < this.certPathLength) {
            int n = -1;
            if (x509Certificate.getVersion() < 3) {
                if (this.i == 1 && X509CertImpl.isSelfIssued(x509Certificate)) {
                    n = Integer.MAX_VALUE;
                }
            } else {
                n = x509Certificate.getBasicConstraints();
            }
            if (n == -1) {
                throw new CertPathValidatorException(string + " check failed: " + "this is not a CA certificate");
            }
            if (!X509CertImpl.isSelfIssued(x509Certificate)) {
                if (this.maxPathLength <= 0) {
                    throw new CertPathValidatorException(string + " check failed: pathLenConstraint violated - " + "this cert must be the last cert in the " + "certification path");
                }
                --this.maxPathLength;
            }
            if (n < this.maxPathLength) {
                this.maxPathLength = n;
            }
        }
        if (debug != null) {
            debug.println("after processing, maxPathLength = " + this.maxPathLength);
            debug.println(string + " verified.");
        }
    }

    static int mergeBasicConstraints(X509Certificate x509Certificate, int n) {
        int n2 = x509Certificate.getBasicConstraints();
        if (!X509CertImpl.isSelfIssued(x509Certificate)) {
            --n;
        }
        if (n2 < n) {
            n = n2;
        }
        return n;
    }
}

