/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class MozillaCertStore
implements CertStore {
    protected static final int VALID_PEER = 1;
    protected static final int TRUSTED_PEER = 2;
    protected static final int VALID_CA = 8;
    protected static final int TRUSTED_CA = 16;
    protected static final int USER = 64;
    protected static final int TRUSTED_CLIENT_CA = 128;
    private Collection certs = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    MozillaCertStore() {
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("mozilla.cert.loading", new Object[]{this.getName()});
        this.certs.clear();
        try {
            Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
            Object object = BrowserKeystore.getJSSCryptoManager();
            Method method = clazz.getMethod("getCACerts", null);
            Object[] objectArray = (Object[])method.invoke(object, null);
            for (int i = 0; i < objectArray.length; ++i) {
                Boolean bl2;
                Object[] objectArray2;
                AccessibleObject accessibleObject;
                Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.X509Certificate", true, ClassLoader.getSystemClassLoader());
                Method method2 = clazz2.getMethod("getNickname", null);
                String string = (String)method2.invoke(objectArray[i], null);
                Class<?> clazz3 = Class.forName("org.mozilla.jss.CryptoManager$CertUsage", true, ClassLoader.getSystemClassLoader());
                Class[] classArray = new Class[]{class$java$lang$String == null ? MozillaCertStore.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE, clazz3};
                Method method3 = clazz.getMethod("isCertValid", classArray);
                if (this.isTrustedSigningCACertStore()) {
                    accessibleObject = clazz3.getField("ObjectSigner");
                    objectArray2 = new Object[]{string, Boolean.FALSE, ((Field)accessibleObject).get(objectArray[i])};
                    bl2 = (Boolean)method3.invoke(object, objectArray2);
                    Field field = clazz3.getField("EmailSigner");
                    objectArray2[2] = field.get(objectArray[i]);
                    Boolean bl3 = (Boolean)method3.invoke(object, objectArray2);
                    if (!bl2.booleanValue() && !bl3.booleanValue()) continue;
                }
                if (this.isTrustedSSLCACertStore() && !(bl2 = (Boolean)method3.invoke(object, objectArray2 = new Object[]{string, Boolean.FALSE, ((Field)(accessibleObject = clazz3.getField("SSLCA"))).get(objectArray[i])})).booleanValue()) continue;
                accessibleObject = clazz2.getMethod("getEncoded", null);
                objectArray2 = (byte[])((Method)accessibleObject).invoke(objectArray[i], null);
                this.generateCertificate((byte[])objectArray2, this.certs);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Trace.msgSecurityPrintln("mozilla.cert.loaded", new Object[]{this.getName()});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new KeyStoreException("Cannot store certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, false);
    }

    public boolean add(Certificate certificate, boolean bl) throws KeyStoreException {
        throw new KeyStoreException("Cannot add certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        throw new KeyStoreException("Cannot remove certificate from Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, false);
    }

    public boolean contains(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("mozilla.cert.instore", new Object[]{this.getName()});
        return this.certs.contains(certificate);
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("mozilla.cert.canverify", new Object[]{this.getName()});
        Trace.msgSecurityPrintln("mozilla.cert.tobeverified", new Object[]{certificate});
        Iterator iterator = this.getCertificates().iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            Trace.msgSecurityPrintln("mozilla.cert.tobecompared", new Object[]{this.getName(), x509Certificate});
            try {
                certificate.verify(x509Certificate.getPublicKey());
                Trace.msgSecurityPrintln("mozilla.cert.verify.ok", new Object[]{this.getName()});
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("mozilla.cert.verify.fail", new Object[]{this.getName()});
        return false;
    }

    public Collection getCertificates() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Iterator iterator = this.certs.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            arrayList.add(certificate);
        }
        return arrayList;
    }

    private void generateCertificate(byte[] byArray, Collection collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection2 = certificateFactory.generateCertificates(byteArrayInputStream);
            Iterator<? extends Certificate> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                collection.add(x509Certificate);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected abstract String getName();

    protected abstract boolean isTrustedSigningCACertStore();

    protected abstract boolean isTrustedSSLCACertStore();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

