/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.DeployFileOutputStream;
import com.sun.deploy.util.Trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class DeployCacheRequest
extends CacheRequest {
    DeployFileOutputStream fos;
    File file;

    public DeployCacheRequest(final URL uRL, final URLConnection uRLConnection, final boolean bl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        DeployCacheRequest.this.file = File.createTempFile("jar_cache", null);
                        DeployCacheRequest.this.fos = new DeployFileOutputStream(DeployCacheRequest.this.file, uRL, uRLConnection, bl);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
        }
    }

    public OutputStream getBody() throws IOException {
        return new BufferedOutputStream(this.fos);
    }

    public void abort() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        if (DeployCacheRequest.this.fos != null) {
                            DeployCacheRequest.this.fos.setAbort(true);
                            DeployCacheRequest.this.fos.close();
                        }
                        if (DeployCacheRequest.this.file != null) {
                            DeployCacheRequest.this.file.delete();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
        }
    }
}

