/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.PipeCloner;
import com.sun.xml.internal.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;

public final class DeferredTransportPipe
extends AbstractTubeImpl {
    private Tube transport;
    private EndpointAddress address;
    private final ClassLoader classLoader;
    private final ClientTubeAssemblerContext context;

    public DeferredTransportPipe(ClassLoader classLoader, ClientPipeAssemblerContext clientPipeAssemblerContext) {
        this(classLoader, new ClientTubeAssemblerContext(clientPipeAssemblerContext.getAddress(), clientPipeAssemblerContext.getWsdlModel(), clientPipeAssemblerContext.getService(), clientPipeAssemblerContext.getBinding(), clientPipeAssemblerContext.getContainer()));
    }

    public DeferredTransportPipe(ClassLoader classLoader, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        this.classLoader = classLoader;
        this.context = clientTubeAssemblerContext;
    }

    public NextAction processException(@NotNull Throwable throwable) {
        return this.transport.processException(throwable);
    }

    public NextAction processRequest(@NotNull Packet packet) {
        if (packet.endpointAddress == this.address) {
            return this.transport.processRequest(packet);
        }
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
        ClientTubeAssemblerContext clientTubeAssemblerContext = new ClientTubeAssemblerContext(packet.endpointAddress, this.context.getWsdlModel(), this.context.getService(), this.context.getBinding(), this.context.getContainer(), this.context.getCodec().copy());
        this.address = packet.endpointAddress;
        this.transport = TransportTubeFactory.create(this.classLoader, clientTubeAssemblerContext);
        assert (this.transport != null);
        return this.transport.processRequest(packet);
    }

    public NextAction processResponse(@NotNull Packet packet) {
        return this.transport.processResponse(packet);
    }

    public void preDestroy() {
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
    }

    public DeferredTransportPipe copy(TubeCloner tubeCloner) {
        DeferredTransportPipe deferredTransportPipe = new DeferredTransportPipe(this.classLoader, this.context);
        tubeCloner.add(this, deferredTransportPipe);
        if (this.transport != null) {
            deferredTransportPipe.transport = ((PipeCloner)tubeCloner).copy(this.transport);
            deferredTransportPipe.address = this.address;
        }
        return deferredTransportPipe;
    }
}

