/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.setup.SetupData.PackageDescription;

public class PackageCollector {
    private PackageCollector() {
    }

    public static void collectInstallPackages(PackageDescription packageData, Vector allPackages) {
        block6: {
            block7: {
                if (packageData.isLeaf()) {
                    if (packageData.getSelectionState() == 1) {
                        allPackages.add(packageData);
                    }
                }
                if (packageData.isLeaf() || packageData.getPackageName() == null || packageData.getPackageName().equals("")) break block6;
                if (packageData.getSelectionState() == 1) break block7;
                if (packageData.getSelectionState() != 2) break block6;
            }
            allPackages.add(packageData);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            PackageCollector.collectInstallPackages(child, allPackages);
        }
    }

    public static void collectUninstallPackages(PackageDescription packageData, Vector allPackages) {
        if (packageData.isLeaf()) {
            if (packageData.getSelectionState() == 3) {
                allPackages.add(0, packageData);
            }
        }
        if (!packageData.isLeaf() && packageData.getPackageName() != null && !packageData.getPackageName().equals("")) {
            if (packageData.getSelectionState() == 3) {
                allPackages.add(0, packageData);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            PackageCollector.collectUninstallPackages(child, allPackages);
        }
    }

    public static void sortPackages(Vector allPackages, Vector sortedPackages, String mode) {
        for (int i = 0; i < allPackages.size(); ++i) {
            boolean integrated = false;
            PackageDescription packageData = (PackageDescription)allPackages.get(i);
            if (i == 0) {
                sortedPackages.add(packageData);
                integrated = true;
                continue;
            }
            int position = packageData.getOrder();
            for (int j = 0; j < sortedPackages.size(); ++j) {
                PackageDescription sortedPackageData = (PackageDescription)sortedPackages.get(j);
                int compare = sortedPackageData.getOrder();
                if (position >= compare) continue;
                sortedPackages.add(j, packageData);
                integrated = true;
                break;
            }
            if (integrated) continue;
            sortedPackages.add(packageData);
        }
        if (mode.equalsIgnoreCase("uninstall")) {
            int number = sortedPackages.size();
            for (int i = 0; i < number; ++i) {
                if (i <= 0) continue;
                PackageDescription sortPackageData = (PackageDescription)sortedPackages.remove(i);
                sortedPackages.add(0, sortPackageData);
            }
        }
    }
}

