/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleInputDeviceProvider;
import com.sun.media.sound.Toolkit;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.TargetDataLine;

class SimpleInputDevice
extends AbstractMixer {
    private AudioFormat format = null;
    private int bufferSize = -1;
    private static final int DEFAULT_BUFFER_TIME = 500;
    private Port[] ports;
    private boolean implStarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleInputDevice(SimpleInputDeviceProvider.InputDeviceInfo inputDeviceInfo) {
        super(inputDeviceInfo, null, null, null);
        AudioFormat[] audioFormatArray;
        Platform.initialize();
        Vector vector = new Vector();
        this.nGetFormats(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), vector, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW, AudioFormat.Encoding.ALAW);
        Vector vector2 = vector;
        synchronized (vector2) {
            audioFormatArray = new AudioFormat[vector.size()];
            for (int i = 0; i < audioFormatArray.length; ++i) {
                audioFormatArray[i] = (AudioFormat)vector.elementAt(i);
            }
        }
        int n = this.nGetNumPorts();
        this.sourceLineInfo = new Port.Info[n];
        this.ports = new Port[n];
        for (int i = 0; i < n; ++i) {
            String string = this.nGetPortName(i);
            this.sourceLineInfo[i] = this.getPortInfo(string);
            this.ports[i] = new InputDevicePort((Port.Info)this.sourceLineInfo[i], this, new Control[0]);
        }
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = new DataLine.Info(TargetDataLine.class, audioFormatArray, 0, -1);
        this.format = vector.size() > 0 ? (AudioFormat)vector.lastElement() : null;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof Port.Info) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (!info2.equals(this.ports[i].getLineInfo())) continue;
                return this.ports[i];
            }
        }
        if (info2 instanceof DataLine.Info) {
            DataLine.Info info3 = (DataLine.Info)info2;
            AudioFormat[] audioFormatArray = info3.getFormats();
            if (audioFormatArray.length == 0) {
                throw new IllegalArgumentException("Line unsupported: " + info);
            }
            if (info3.getLineClass().isAssignableFrom(InputDeviceDataLine.class)) {
                int n = -1;
                AudioFormat audioFormat = null;
                if (info instanceof DataLine.Info) {
                    AudioFormat[] audioFormatArray2 = ((DataLine.Info)info).getFormats();
                    if (audioFormatArray2 != null && audioFormatArray2.length > 0) {
                        audioFormat = audioFormatArray2[audioFormatArray2.length - 1];
                    }
                    if ((n = ((DataLine.Info)info).getMaxBufferSize()) <= -1) {
                        n = ((DataLine.Info)info).getMinBufferSize();
                    }
                    if (n <= 0) {
                        n = -1;
                    }
                }
                if (audioFormat == null) {
                    audioFormat = audioFormatArray[audioFormatArray.length - 1];
                }
                if (n <= -1) {
                    n = (int)Toolkit.millis2bytes(audioFormat, 500L);
                }
                return new InputDeviceDataLine(info3, this, audioFormat, n);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        if (info2 instanceof DataLine.Info) {
            return -1;
        }
        return 0;
    }

    public void implOpen() throws LineUnavailableException {
        JSSecurityManager.checkRecordPermission();
        if (this.format == null) {
            throw new LineUnavailableException("line not available");
        }
        if (this.bufferSize < 0) {
            this.bufferSize = 0;
        }
        int n = 8;
        Toolkit.isFullySpecifiedAudioFormat(this.format);
        int n2 = 0;
        if (AudioFormat.Encoding.ULAW.equals(this.format.getEncoding())) {
            n2 = 1;
        } else if (AudioFormat.Encoding.ALAW.equals(this.format.getEncoding())) {
            n2 = 2;
        }
        this.nOpen(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), n2, (int)this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), this.bufferSize / (this.format.getFrameSize() * n));
        this.bufferSize = this.nGetBufferSizeInFrames() * this.format.getFrameSize() * n;
    }

    public void implClose() {
        JSSecurityManager.checkRecordPermission();
        this.nClose();
        this.implStarted = false;
    }

    protected void implStart() {
        JSSecurityManager.checkRecordPermission();
        if (!this.implStarted) {
            this.nStart();
            this.implStarted = true;
        } else {
            this.nResume();
        }
    }

    protected void implStop() {
        JSSecurityManager.checkRecordPermission();
        this.nPause();
    }

    private Port.Info getPortInfo(String string) {
        if (string.equals(Port.Info.MICROPHONE.toString())) {
            return Port.Info.MICROPHONE;
        }
        if (string.equals(Port.Info.LINE_IN.toString())) {
            return Port.Info.LINE_IN;
        }
        if (string.equals(Port.Info.COMPACT_DISC.toString())) {
            return Port.Info.COMPACT_DISC;
        }
        return new InputDevicePortInfo(string);
    }

    private void callbackCaptureStreamDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamPutData(byte[] byArray, int n) {
        int n2 = n * this.format.getFrameSize();
        InputDeviceDataLine inputDeviceDataLine = null;
        Vector vector = null;
        Vector vector2 = this.targetLines;
        synchronized (vector2) {
            if (this.targetLines.size() == 1) {
                inputDeviceDataLine = (InputDeviceDataLine)this.targetLines.elementAt(0);
            } else {
                vector = (Vector)this.targetLines.clone();
            }
        }
        if (inputDeviceDataLine != null) {
            inputDeviceDataLine.fillBuffer(byArray, n2);
        } else {
            for (int i = 0; i < this.targetLines.size(); ++i) {
                inputDeviceDataLine = (InputDeviceDataLine)this.targetLines.elementAt(i);
                inputDeviceDataLine.fillBuffer(byArray, n2);
            }
        }
    }

    private native void nGetFormats(int var1, Vector var2, AudioFormat.Encoding var3, AudioFormat.Encoding var4, AudioFormat.Encoding var5, AudioFormat.Encoding var6);

    private native void nOpen(int var1, int var2, float var3, int var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose();

    private native void nStart();

    private native void nPause();

    private native void nResume();

    private native void nDrain();

    private native void nFlush();

    private native long nGetPosition();

    private native int nGetBufferSizeInFrames();

    private native int nGetNumPorts();

    private native String nGetPortName(int var1);

    private static class InputDeviceDataLine
    extends AbstractDataLine
    implements TargetDataLine {
        private CircularBuffer circularBuffer = null;
        private SimpleInputDevice sid;

        private InputDeviceDataLine(DataLine.Info info, SimpleInputDevice simpleInputDevice, AudioFormat audioFormat, int n) {
            super(info, simpleInputDevice, null, audioFormat, n);
            this.sid = simpleInputDevice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) {
            int n3 = n2;
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n2 + " bytes )");
            }
            int n4 = 0;
            int n5 = 0;
            while (this.isOpen() && this.isStartedRunning() && n4 < n3) {
                n5 = this.circularBuffer.read(byArray, n, n3 - n4);
                n += n5;
                if ((n4 += n5) >= n3) continue;
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return n4;
        }

        public int available() {
            return this.circularBuffer.bytesAvailableToRead();
        }

        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            JSSecurityManager.checkRecordPermission();
            if (n < 0 || n == -1) {
                n = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            this.checkFormat(audioFormat);
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            boolean bl = false;
            boolean bl2 = false;
            if (audioFormat.getSampleSizeInBits() <= 8 && AudioFormat.Encoding.PCM_SIGNED.equals(audioFormat.getEncoding()) && !Platform.isSigned8()) {
                bl = true;
            } else if (audioFormat.getSampleSizeInBits() <= 8 && AudioFormat.Encoding.PCM_UNSIGNED.equals(audioFormat.getEncoding()) && Platform.isSigned8()) {
                bl = true;
            }
            if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
                bl2 = true;
            }
            this.circularBuffer = new CircularBuffer(n, bl, bl2);
            this.bufferSize = n;
            this.format = audioFormat;
        }

        void implClose() {
            JSSecurityManager.checkRecordPermission();
        }

        public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
            if (!this.mixer.isOpen()) {
                this.sid.format = audioFormat;
                this.sid.bufferSize = n;
            }
            super.open(audioFormat, n);
        }

        void implStart() {
            JSSecurityManager.checkRecordPermission();
        }

        void implStop() {
            JSSecurityManager.checkRecordPermission();
            this.setActive(false);
            this.setStarted(false);
        }

        public void drain() {
            if (this.isOpen()) {
                this.circularBuffer.drain();
                this.sid.nDrain();
            }
        }

        public void flush() {
            if (this.isOpen()) {
                this.circularBuffer.flush();
                this.sid.nFlush();
            }
        }

        public long getLongFramePosition() {
            return this.isOpen() ? this.sid.nGetPosition() : super.getLongFramePosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer(byte[] byArray, int n) {
            if (this.isOpen() && this.isStartedRunning()) {
                if (!this.isActive()) {
                    this.setActive(true);
                    this.setStarted(true);
                }
                int n2 = this.circularBuffer.writeover(byArray, 0, n);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                if (n2 > 0) {
                    // empty if block
                }
            }
        }

        private void checkFormat(AudioFormat audioFormat) throws LineUnavailableException {
            if (this.sid.isOpen()) {
                boolean bl;
                AudioFormat.Encoding encoding = audioFormat.getEncoding();
                AudioFormat.Encoding encoding2 = this.sid.format.getEncoding();
                boolean bl2 = bl = encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding2.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(encoding2);
                if (bl) {
                    audioFormat = new AudioFormat(encoding2, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), this.sid.format.isBigEndian());
                }
                if (!bl || !audioFormat.matches(this.sid.format)) {
                    throw new LineUnavailableException("Requested format incompatible with already established device format: " + this.sid.format);
                }
            }
        }
    }

    private class InputDevicePort
    extends AbstractLine
    implements Port {
        private InputDevicePort(Port.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
            super(info, abstractMixer, controlArray);
        }

        public synchronized void open() throws LineUnavailableException {
            if (!this.isOpen()) {
                JSSecurityManager.checkRecordPermission();
                this.mixer.open(this);
                this.setOpen(true);
            }
        }

        public synchronized void close() {
            if (this.isOpen()) {
                JSSecurityManager.checkRecordPermission();
                this.setOpen(false);
                this.mixer.close(this);
            }
        }
    }

    private static class InputDevicePortInfo
    extends Port.Info {
        private InputDevicePortInfo(String string) {
            super(Port.class, string, true);
        }
    }
}

