/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Panel.ChooseInstallationType;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Calculator;
import org.openoffice.setup.Util.Dumper;
import org.openoffice.setup.Util.ModuleCtrl;
import org.openoffice.setup.Util.PackageCollector;

public class ChooseInstallationTypeCtrl
extends PanelController
implements ActionListener {
    private String helpFile = "String_Helpfile_ChooseInstallationType";

    public ChooseInstallationTypeCtrl() {
        super("ChooseInstallationType", new ChooseInstallationType());
    }

    public String getNext() {
        InstallData data = InstallData.getInstance();
        if (data.getInstallationType().equals(data.getCustomActionCommand())) {
            return new String("ChooseComponents");
        }
        if (data.getInstallationType().equals(data.getTypicalActionCommand())) {
            return new String("InstallationImminent");
        }
        System.err.println("Error: Unknown installation type!");
        return new String("Error");
    }

    public String getPrevious() {
        InstallData data = InstallData.getInstance();
        if (data.isRootInstallation()) {
            if (data.hideEula()) {
                return new String("Prologue");
            }
            return new String("AcceptLicense");
        }
        return new String("ChooseDirectory");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    public void beforeShow() {
        InstallData data = InstallData.getInstance();
        ChooseInstallationType panel = (ChooseInstallationType)this.getPanel();
        panel.setActionListener(this);
        panel.setTypicalActionCommand(data.getTypicalActionCommand());
        panel.setCustomActionCommand(data.getCustomActionCommand());
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        ChooseInstallationType panel = (ChooseInstallationType)this.getPanel();
        panel.removeActionListener(this);
        if (nextButtonPressed) {
            InstallData data = InstallData.getInstance();
            PackageDescription packageData = SetupDataProvider.getPackageDescription();
            if (data.getInstallationType().equals(data.getTypicalActionCommand())) {
                if (data.typicalSelectionStateSaved()) {
                    ModuleCtrl.restoreTypicalSelectionStates(packageData);
                }
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseInstallationType: Before setHiddenModuleSettingsInstall");
                }
                ModuleCtrl.setHiddenModuleSettingsInstall(packageData);
                if (data.logModuleStates()) {
                    Dumper.logModuleStates(packageData, "ChooseInstallationType: After setHiddenModuleSettingsInstall");
                }
                Vector installPackages = new Vector();
                PackageCollector.collectInstallPackages(packageData, installPackages);
                data.setInstallPackages(installPackages);
                if (Calculator.notEnoughDiscSpace(data)) {
                    repeatDialog = true;
                }
            }
            if (data.getInstallationType().equals(data.getCustomActionCommand())) {
                if (!data.typicalSelectionStateSaved()) {
                    ModuleCtrl.saveTypicalSelectionStates(packageData);
                    data.setTypicalSelectionStateSaved(true);
                }
                if (data.customSelectionStateSaved()) {
                    ModuleCtrl.restoreCustomSelectionStates(packageData);
                }
            }
        }
        return repeatDialog;
    }

    public void actionPerformed(ActionEvent evt) {
        InstallData data = InstallData.getInstance();
        if (evt.getActionCommand().equals(data.getTypicalActionCommand())) {
            data.setInstallationType(data.getTypicalActionCommand());
        } else if (evt.getActionCommand().equals(data.getCustomActionCommand())) {
            data.setInstallationType(data.getCustomActionCommand());
        }
    }
}

