/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public abstract class SnmpTableCache
implements Serializable {
    protected long validity;
    protected transient WeakReference datas;

    protected boolean isObsolete(SnmpCachedData snmpCachedData) {
        if (snmpCachedData == null) {
            return true;
        }
        if (this.validity < 0L) {
            return false;
        }
        return System.currentTimeMillis() - snmpCachedData.lastUpdated > this.validity;
    }

    protected SnmpCachedData getCachedDatas() {
        if (this.datas == null) {
            return null;
        }
        SnmpCachedData snmpCachedData = (SnmpCachedData)this.datas.get();
        if (snmpCachedData == null || this.isObsolete(snmpCachedData)) {
            return null;
        }
        return snmpCachedData;
    }

    protected synchronized SnmpCachedData getTableDatas(Object object) {
        SnmpCachedData snmpCachedData = this.getCachedDatas();
        if (snmpCachedData != null) {
            return snmpCachedData;
        }
        SnmpCachedData snmpCachedData2 = this.updateCachedDatas(object);
        if (this.validity != 0L) {
            this.datas = new WeakReference<SnmpCachedData>(snmpCachedData2);
        }
        return snmpCachedData2;
    }

    protected abstract SnmpCachedData updateCachedDatas(Object var1);

    public abstract SnmpTableHandler getTableHandler();
}

