/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MScrollbarPeer
extends MComponentPeer
implements ScrollbarPeer {
    private boolean inUpCall = false;
    private boolean dragInProgress = false;

    native void create(MComponentPeer var1);

    MScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    private static native void initIDs();

    public native void pSetValues(int var1, int var2, int var3, int var4);

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    int getDefaultDimension() {
        if (System.getProperty("os.name").equals("Linux")) {
            return 15;
        }
        return 19;
    }

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(this.getDefaultDimension(), 50);
        }
        return new Dimension(50, this.getDefaultDimension());
    }

    private void postAdjustmentEvent(final int n, final int n2, final boolean bl) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                MScrollbarPeer.this.inUpCall = true;
                scrollbar.setValueIsAdjusting(bl);
                scrollbar.setValue(n2);
                MScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, n, n2, bl));
                MScrollbarPeer.this.inUpCall = false;
            }
        });
    }

    void lineUp(int n) {
        this.postAdjustmentEvent(2, n, false);
    }

    void lineDown(int n) {
        this.postAdjustmentEvent(1, n, false);
    }

    void pageUp(int n) {
        this.postAdjustmentEvent(3, n, false);
    }

    void pageDown(int n) {
        this.postAdjustmentEvent(4, n, false);
    }

    void warp(int n) {
        this.postAdjustmentEvent(5, n, false);
    }

    void drag(int n) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, n, true);
    }

    void dragEnd(final int n) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                MScrollbarPeer.this.inUpCall = true;
                scrollbar.setValueIsAdjusting(false);
                MScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, 5, n, false));
                MScrollbarPeer.this.inUpCall = false;
            }
        });
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (!this.inUpCall) {
            this.pSetValues(n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Dimension dimension = scrollbar.size();
        Color color = scrollbar.getBackground();
        boolean bl = scrollbar.getOrientation() == 0;
        this.drawScrollbar(graphics, color, bl ? dimension.height : dimension.width, bl ? dimension.width : dimension.height, scrollbar.getMinimum(), scrollbar.getMaximum(), scrollbar.getValue(), scrollbar.getVisible(), bl);
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    protected boolean shouldFocusOnClick() {
        return true;
    }

    static {
        MScrollbarPeer.initIDs();
    }
}

