/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleInputDevice;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class SimpleInputDeviceProvider
extends MixerProvider {
    private static InputDeviceInfo[] infos;
    private static SimpleInputDevice[] devices;

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        if (infos.length > 0) {
            System.arraycopy(infos, 0, infoArray, 0, infos.length);
        }
        return infoArray;
    }

    public Mixer getMixer(Mixer.Info info) {
        for (int i = 0; i < infos.length; ++i) {
            if (info != infos[i]) continue;
            return this.getDevice(infos[i]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(InputDeviceInfo inputDeviceInfo) {
        int n = inputDeviceInfo.getIndex();
        if (devices[n] == null) {
            SimpleInputDeviceProvider.devices[n] = new SimpleInputDevice(inputDeviceInfo);
        }
        return devices[n];
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        int n = 0;
        if (!Platform.isDirectAudioEnabled()) {
            n = SimpleInputDeviceProvider.nGetNumDevices();
        }
        infos = new InputDeviceInfo[n];
        devices = new SimpleInputDevice[n];
        for (int i = 0; i < infos.length; ++i) {
            String string = SimpleInputDeviceProvider.nGetName(i);
            String string2 = SimpleInputDeviceProvider.nGetVendor(i);
            String string3 = SimpleInputDeviceProvider.nGetDescription(i);
            String string4 = SimpleInputDeviceProvider.nGetVersion(i);
            SimpleInputDeviceProvider.infos[i] = new InputDeviceInfo(string, string2, string3, string4, i, SimpleInputDeviceProvider.class);
        }
    }

    static class InputDeviceInfo
    extends Mixer.Info {
        private int index;
        private Class providerClass;

        private InputDeviceInfo(String string, String string2, String string3, String string4, int n, Class clazz) {
            super(string, string2, string3, string4);
            this.index = n;
            this.providerClass = clazz;
        }

        int getIndex() {
            return this.index;
        }
    }
}

