/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.InternetHeaders;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEConfig;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEEvent;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParser;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMEMessage {
    private static final Logger LOGGER = Logger.getLogger(MIMEMessage.class.getName());
    MIMEConfig config;
    private final InputStream in;
    private final List<MIMEPart> partsList;
    private final Map<String, MIMEPart> partsMap;
    private final Iterator<MIMEEvent> it;
    private boolean parsed;
    private MIMEPart currentPart;
    private int currentIndex;

    public MIMEMessage(InputStream inputStream, String string) {
        this(inputStream, string, new MIMEConfig());
    }

    public MIMEMessage(InputStream inputStream, String string, MIMEConfig mIMEConfig) {
        this.in = inputStream;
        this.config = mIMEConfig;
        MIMEParser mIMEParser = new MIMEParser(inputStream, string, mIMEConfig);
        this.it = mIMEParser.iterator();
        this.partsList = new ArrayList<MIMEPart>();
        this.partsMap = new HashMap<String, MIMEPart>();
        if (mIMEConfig.isParseEagerly()) {
            this.parseAll();
        }
    }

    public List<MIMEPart> getAttachments() {
        if (!this.parsed) {
            this.parseAll();
        }
        return this.partsList;
    }

    public MIMEPart getPart(int n) {
        MIMEPart mIMEPart;
        LOGGER.fine("index=" + n);
        MIMEPart mIMEPart2 = mIMEPart = n < this.partsList.size() ? this.partsList.get(n) : null;
        if (this.parsed && mIMEPart == null) {
            throw new MIMEParsingException("There is no " + n + " attachment part ");
        }
        if (mIMEPart == null) {
            mIMEPart = new MIMEPart(this);
            this.partsList.add(n, mIMEPart);
        }
        LOGGER.fine("Got attachment at index=" + n + " attachment=" + mIMEPart);
        return mIMEPart;
    }

    public MIMEPart getPart(String string) {
        LOGGER.fine("Content-ID=" + string);
        MIMEPart mIMEPart = this.getDecodedCidPart(string);
        if (this.parsed && mIMEPart == null) {
            throw new MIMEParsingException("There is no attachment part with Content-ID = " + string);
        }
        if (mIMEPart == null) {
            mIMEPart = new MIMEPart(this, string);
            this.partsMap.put(string, mIMEPart);
        }
        LOGGER.fine("Got attachment for Content-ID=" + string + " attachment=" + mIMEPart);
        return mIMEPart;
    }

    private MIMEPart getDecodedCidPart(String string) {
        MIMEPart mIMEPart = this.partsMap.get(string);
        if (mIMEPart == null && string.indexOf(37) != -1) {
            try {
                String string2 = URLDecoder.decode(string, "utf-8");
                mIMEPart = this.partsMap.get(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return mIMEPart;
    }

    public void parseAll() {
        while (this.makeProgress()) {
        }
    }

    public synchronized boolean makeProgress() {
        if (!this.it.hasNext()) {
            return false;
        }
        MIMEEvent mIMEEvent = this.it.next();
        switch (mIMEEvent.getEventType()) {
            case START_MESSAGE: {
                LOGGER.fine("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.START_MESSAGE));
                break;
            }
            case START_PART: {
                LOGGER.fine("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.START_PART));
                break;
            }
            case HEADERS: {
                String string;
                LOGGER.fine("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.HEADERS));
                MIMEEvent.Headers headers = (MIMEEvent.Headers)mIMEEvent;
                InternetHeaders internetHeaders = headers.getHeaders();
                List<String> list = internetHeaders.getHeader("content-id");
                String string2 = string = list != null ? list.get(0) : this.currentIndex + "";
                if (string.length() > 2 && string.charAt(0) == '<') {
                    string = string.substring(1, string.length() - 1);
                }
                MIMEPart mIMEPart = this.currentIndex < this.partsList.size() ? this.partsList.get(this.currentIndex) : null;
                MIMEPart mIMEPart2 = this.getDecodedCidPart(string);
                if (mIMEPart == null && mIMEPart2 == null) {
                    this.currentPart = this.getPart(string);
                    this.partsList.add(this.currentIndex, this.currentPart);
                } else if (mIMEPart == null) {
                    this.currentPart = mIMEPart2;
                    this.partsList.add(this.currentIndex, mIMEPart2);
                } else if (mIMEPart2 == null) {
                    this.currentPart = mIMEPart;
                    this.currentPart.setContentId(string);
                    this.partsMap.put(string, this.currentPart);
                } else if (mIMEPart != mIMEPart2) {
                    throw new MIMEParsingException("Created two different attachments using Content-ID and index");
                }
                this.currentPart.setHeaders(internetHeaders);
                break;
            }
            case CONTENT: {
                LOGGER.finer("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.CONTENT));
                MIMEEvent.Content content = (MIMEEvent.Content)mIMEEvent;
                ByteBuffer byteBuffer = content.getData();
                this.currentPart.addBody(byteBuffer);
                break;
            }
            case END_PART: {
                LOGGER.fine("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.END_PART));
                this.currentPart.doneParsing();
                ++this.currentIndex;
                break;
            }
            case END_MESSAGE: {
                LOGGER.fine("MIMEEvent=" + (Object)((Object)MIMEEvent.EVENT_TYPE.END_MESSAGE));
                this.parsed = true;
                try {
                    this.in.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new MIMEParsingException(iOException);
                }
            }
            default: {
                throw new MIMEParsingException("Unknown Parser state = " + (Object)((Object)mIMEEvent.getEventType()));
            }
        }
        return true;
    }
}

