/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;

public abstract class MappedByteBuffer
extends ByteBuffer {
    volatile boolean isAMappedBuffer;

    MappedByteBuffer(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.isAMappedBuffer = bl;
    }

    MappedByteBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.isAMappedBuffer = false;
    }

    private void checkMapped() {
        if (!this.isAMappedBuffer) {
            throw new UnsupportedOperationException();
        }
    }

    private int pagePosition() {
        assert (this.isAMappedBuffer);
        int n = Bits.pageSize();
        int n2 = (int)(this.address % (long)n);
        return n2 >= 0 ? n2 : n + n2;
    }

    public final boolean isLoaded() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return true;
        }
        int n = this.pagePosition();
        return this.isLoaded0(this.address - (long)n, (long)this.capacity() + (long)n, Bits.pageSize());
    }

    public final MappedByteBuffer load() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return this;
        }
        int n = this.pagePosition();
        this.load0(this.address - (long)n, (long)this.capacity() + (long)n, Bits.pageSize());
        return this;
    }

    public final MappedByteBuffer force() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return this;
        }
        int n = this.pagePosition();
        this.force0(this.address - (long)n, (long)this.capacity() + (long)n);
        return this;
    }

    private native boolean isLoaded0(long var1, long var3, int var5);

    private native int load0(long var1, long var3, int var5);

    private native void force0(long var1, long var3);
}

