/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class PlainClient
implements SaslClient {
    private boolean completed = false;
    private byte[] pw;
    private String authorizationID;
    private String authenticationID;
    private static byte SEP = 0;

    PlainClient(String string, String string2, byte[] byArray) throws SaslException {
        if (string2 == null || byArray == null) {
            throw new SaslException("PLAIN: authorization ID and password must be specified");
        }
        this.authorizationID = string;
        this.authenticationID = string2;
        this.pw = byArray;
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        this.completed = true;
        try {
            byte[] byArray2 = this.authorizationID != null ? this.authorizationID.getBytes("UTF8") : null;
            byte[] byArray3 = this.authenticationID.getBytes("UTF8");
            byte[] byArray4 = new byte[this.pw.length + byArray3.length + 2 + (byArray2 == null ? 0 : byArray2.length)];
            int n = 0;
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                n = byArray2.length;
            }
            byArray4[n++] = SEP;
            System.arraycopy(byArray3, 0, byArray4, n, byArray3.length);
            n += byArray3.length;
            byArray4[n++] = SEP;
            System.arraycopy(this.pw, 0, byArray4, n, this.pw.length);
            this.clearPassword();
            return byArray4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("Cannot get UTF-8 encoding of ids", unsupportedEncodingException);
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    private void clearPassword() {
        if (this.pw != null) {
            for (int i = 0; i < this.pw.length; ++i) {
                this.pw[i] = 0;
            }
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }
}

