/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.MessageDigest;
import java.util.Random;
import sun.security.krb5.KrbCryptoException;

public final class Confounder {
    private static long count = 0L;
    private static long index = 0L;
    private static long lastKeyTime = 0L;
    private static Random rand = new Random();
    private static byte[] buffer = new byte[16];

    private static synchronized void reinitialize() throws KrbCryptoException {
        long l = System.currentTimeMillis();
        rand.setSeed(lastKeyTime + l + count + index);
        ++count;
        for (int i = 0; i < buffer.length; ++i) {
            Confounder.buffer[i] = (byte)rand.nextInt();
        }
        MessageDigest messageDigest = null;
        byte[] byArray = new byte[16];
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new KrbCryptoException("JCE provider may not be installed. " + exception.getMessage());
        }
        try {
            messageDigest.update(buffer);
            byArray = messageDigest.digest();
            buffer = byArray;
        }
        catch (Exception exception) {
            throw new KrbCryptoException(exception.getMessage());
        }
    }

    public static synchronized byte[] bytes(int n) throws KrbCryptoException {
        lastKeyTime = System.currentTimeMillis();
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            if (index % (long)buffer.length == 0L) {
                Confounder.reinitialize();
            }
            byArray[i] = buffer[(int)(index % (long)buffer.length)];
            ++index;
        }
        return byArray;
    }

    public static synchronized int intValue() throws KrbCryptoException {
        byte[] byArray = Confounder.bytes(4);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += byArray[i] * (0x10 ^ i);
        }
        return n;
    }

    public static synchronized long longValue() throws KrbCryptoException {
        byte[] byArray = Confounder.bytes(4);
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l += (long)byArray[i] * (0x10L ^ (long)i);
        }
        return l;
    }
}

