/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.util.KrbBitArray;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class APOptions
extends KrbBitArray {
    public APOptions() {
        super(32);
    }

    public APOptions(int n) throws Asn1Exception {
        super(32);
        this.set(n, true);
    }

    public APOptions(int n, byte[] byArray) throws Asn1Exception {
        super(n, byArray);
        if (n > byArray.length * 8 || n > 32) {
            throw new Asn1Exception(502);
        }
    }

    public APOptions(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public APOptions(DerValue derValue) throws IOException, Asn1Exception {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public static APOptions parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new APOptions(derValue2);
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.toBooleanArray()));
        return derOutputStream.toByteArray();
    }
}

