/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncryptedData
implements Cloneable {
    int eType;
    Integer kvno;
    byte[] cipher;
    byte[] plain;
    public static final int ETYPE_NULL = 0;
    public static final int ETYPE_DES_CBC_CRC = 1;
    public static final int ETYPE_DES_CBC_MD4 = 2;
    public static final int ETYPE_DES_CBC_MD5 = 3;
    public static final int ETYPE_ARCFOUR_HMAC = 23;
    public static final int ETYPE_ARCFOUR_HMAC_EXP = 24;
    public static final int ETYPE_DES3_CBC_HMAC_SHA1_KD = 16;
    public static final int ETYPE_AES128_CTS_HMAC_SHA1_96 = 17;
    public static final int ETYPE_AES256_CTS_HMAC_SHA1_96 = 18;

    private EncryptedData() {
    }

    public Object clone() {
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.eType = this.eType;
        if (this.kvno != null) {
            encryptedData.kvno = new Integer(this.kvno);
        }
        if (this.cipher != null) {
            encryptedData.cipher = new byte[this.cipher.length];
            System.arraycopy(this.cipher, 0, encryptedData.cipher, 0, this.cipher.length);
        }
        return encryptedData;
    }

    public EncryptedData(int n, Integer n2, byte[] byArray) {
        this.eType = n;
        this.kvno = n2;
        this.cipher = byArray;
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, int n) throws KdcErrException, KrbCryptoException {
        EType eType = EType.getInstance(encryptionKey.getEType());
        this.cipher = eType.encrypt(byArray, encryptionKey.getBytes(), n);
        this.eType = encryptionKey.getEType();
        this.kvno = encryptionKey.getKeyVersionNumber();
    }

    public byte[] decrypt(EncryptionKey encryptionKey, int n) throws KdcErrException, KrbApErrException, KrbCryptoException {
        if (this.eType != encryptionKey.getEType()) {
            throw new KrbCryptoException("EncryptedData is encrypted using keytype " + EType.toString(this.eType) + " but decryption key is of type " + EType.toString(encryptionKey.getEType()));
        }
        EType eType = EType.getInstance(this.eType);
        this.plain = eType.decrypt(this.cipher, encryptionKey.getBytes(), n);
        this.cipher = null;
        return eType.decryptedData(this.plain);
    }

    private byte[] decryptedData() throws KdcErrException {
        if (this.plain != null) {
            EType eType = EType.getInstance(this.eType);
            return eType.decryptedData(this.plain);
        }
        return null;
    }

    private EncryptedData(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.eType = derValue2.getData().getBigInteger().intValue();
        if ((derValue.getData().peekByte() & 0x1F) == 1) {
            derValue2 = derValue.getData().getDerValue();
            int n = derValue2.getData().getBigInteger().intValue();
            this.kvno = new Integer(n);
        } else {
            this.kvno = null;
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.cipher = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.eType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        if (this.kvno != null) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.kvno.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.putOctetString(this.cipher);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static EncryptedData parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptedData(derValue2);
    }

    public byte[] reset(byte[] byArray, boolean bl) {
        byte[] byArray2 = null;
        if (bl) {
            if ((byArray[1] & 0xFF) < 128) {
                byArray2 = new byte[byArray[1] + 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray[1] + 2);
            } else if ((byArray[1] & 0xFF) > 128) {
                int n = byArray[1] & 0x7F;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 |= (byArray[i + 2] & 0xFF) << 8 * (n - i - 1);
                }
                byArray2 = new byte[n2 + n + 2];
                System.arraycopy(byArray, 0, byArray2, 0, n2 + n + 2);
            }
        } else {
            byArray2 = new byte[byArray.length - byArray[byArray.length - 1]];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length - byArray[byArray.length - 1]);
        }
        return byArray2;
    }

    public int getEType() {
        return this.eType;
    }

    public Integer getKeyVersionNumber() {
        return this.kvno;
    }

    public byte[] getBytes() {
        return this.cipher;
    }
}

