/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.RMIExporter;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final Map env;

    public RMIJRMPServerImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, Map<String, ?> map) throws IOException {
        super(map);
        if (n < 0) {
            throw new IllegalArgumentException("Negative port: " + n);
        }
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
        this.env = map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    protected void export() throws IOException {
        this.export(this);
    }

    private void export(Remote remote) throws RemoteException {
        RMIExporter rMIExporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (rMIExporter == null) {
            UnicastRemoteObject.exportObject(remote, this.port, this.csf, this.ssf);
        } else {
            rMIExporter.exportObject(remote, this.port, this.csf, this.ssf);
        }
    }

    private void unexport(Remote remote, boolean bl) throws NoSuchObjectException {
        RMIExporter rMIExporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (rMIExporter == null) {
            UnicastRemoteObject.unexportObject(remote, bl);
        } else {
            rMIExporter.unexportObject(remote, bl);
        }
    }

    @Override
    protected String getProtocol() {
        return "rmi";
    }

    @Override
    public Remote toStub() throws IOException {
        return RemoteObject.toStub(this);
    }

    @Override
    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        this.export(rMIConnectionImpl);
        return rMIConnectionImpl;
    }

    @Override
    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        this.unexport(rMIConnection, true);
    }

    @Override
    protected void closeServer() throws IOException {
        this.unexport(this, true);
    }
}

