/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.dom;

import com.sun.xml.internal.fastinfoset.Encoder;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.internal.fastinfoset.util.NamespaceContextImplementation;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMDocumentSerializer
extends Encoder {
    protected NamespaceContextImplementation _namespaceScopeContext = new NamespaceContextImplementation();
    protected Node[] _attributes = new Node[32];

    public final void serialize(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                this.serialize((Document)node);
                break;
            }
            case 1: {
                this.serializeElementAsDocument(node);
                break;
            }
            case 8: {
                this.serializeComment(node);
                break;
            }
            case 7: {
                this.serializeProcessingInstruction(node);
            }
        }
    }

    public final void serialize(Document document) throws IOException {
        this.reset();
        this.encodeHeader(false);
        this.encodeInitialVocabulary();
        NodeList nodeList = document.getChildNodes();
        block5: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    this.serializeElement(node);
                    continue block5;
                }
                case 8: {
                    this.serializeComment(node);
                    continue block5;
                }
                case 7: {
                    this.serializeProcessingInstruction(node);
                }
            }
        }
        this.encodeDocumentTermination();
    }

    protected final void serializeElementAsDocument(Node node) throws IOException {
        this.reset();
        this.encodeHeader(false);
        this.encodeInitialVocabulary();
        this.serializeElement(node);
        this.encodeDocumentTermination();
    }

    protected final void serializeElement(Node node) throws IOException {
        Object object;
        Object object2;
        String string;
        Object object3;
        this.encodeTermination();
        int n = 0;
        this._namespaceScopeContext.pushContext();
        if (node.hasAttributes()) {
            object3 = node.getAttributes();
            for (int i = 0; i < object3.getLength(); ++i) {
                Node node2 = object3.item(i);
                string = node2.getNamespaceURI();
                if (string != null && string.equals("http://www.w3.org/2000/xmlns/")) {
                    object2 = node2.getLocalName();
                    object = node2.getNodeValue();
                    if (object2 == "xmlns" || ((String)object2).equals("xmlns")) {
                        object2 = "";
                    }
                    this._namespaceScopeContext.declarePrefix((String)object2, (String)object);
                    continue;
                }
                if (n == this._attributes.length) {
                    object2 = new Node[n * 3 / 2 + 1];
                    System.arraycopy(this._attributes, 0, object2, 0, n);
                    this._attributes = object2;
                }
                this._attributes[n++] = node2;
                object2 = node2.getNamespaceURI();
                object = node2.getPrefix();
                if (object == null || this._namespaceScopeContext.getNamespaceURI((String)object).equals(object2)) continue;
                this._namespaceScopeContext.declarePrefix((String)object, (String)object2);
            }
        }
        object3 = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (string2 == null) {
            string2 = "";
        }
        if (object3 != null && !this._namespaceScopeContext.getNamespaceURI(string2).equals(object3)) {
            this._namespaceScopeContext.declarePrefix(string2, (String)object3);
        }
        if (!this._namespaceScopeContext.isCurrentContextEmpty()) {
            if (n > 0) {
                this.write(120);
            } else {
                this.write(56);
            }
            for (int i = this._namespaceScopeContext.getCurrentContextStartIndex(); i < this._namespaceScopeContext.getCurrentContextEndIndex(); ++i) {
                string = this._namespaceScopeContext.getPrefix(i);
                object2 = this._namespaceScopeContext.getNamespaceURI(i);
                this.encodeNamespaceAttribute(string, (String)object2);
            }
            this.write(240);
            this._b = 0;
        } else {
            this._b = n > 0 ? 64 : 0;
        }
        Object object4 = object3;
        object4 = object4 == null ? "" : object4;
        this.encodeElement((String)object4, node.getNodeName(), node.getLocalName());
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                object2 = this._attributes[i];
                this._attributes[i] = null;
                object4 = object2.getNamespaceURI();
                object4 = object4 == null ? "" : object4;
                this.encodeAttribute((String)object4, object2.getNodeName(), object2.getLocalName());
                object = object2.getNodeValue();
                boolean bl = this.isAttributeValueLengthMatchesLimit(((String)object).length());
                this.encodeNonIdentifyingStringOnFirstBit((String)object, this._v.attributeValue, bl, false);
            }
            this._b = 240;
            this._terminate = true;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            block10: for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                switch (object.getNodeType()) {
                    case 1: {
                        this.serializeElement((Node)object);
                        continue block10;
                    }
                    case 3: {
                        this.serializeText((Node)object);
                        continue block10;
                    }
                    case 4: {
                        this.serializeCDATA((Node)object);
                        continue block10;
                    }
                    case 8: {
                        this.serializeComment((Node)object);
                        continue block10;
                    }
                    case 7: {
                        this.serializeProcessingInstruction((Node)object);
                    }
                }
            }
        }
        this.encodeElementTermination();
        this._namespaceScopeContext.popContext();
    }

    protected final void serializeText(Node node) throws IOException {
        int n;
        String string = node.getNodeValue();
        int n2 = n = string != null ? string.length() : 0;
        if (n == 0) {
            return;
        }
        if (n < this._charBuffer.length) {
            string.getChars(0, n, this._charBuffer, 0);
            if (this.getIgnoreWhiteSpaceTextContent() && DOMDocumentSerializer.isWhiteSpace(this._charBuffer, 0, n)) {
                return;
            }
            this.encodeTermination();
            this.encodeCharacters(this._charBuffer, 0, n);
        } else {
            char[] cArray = string.toCharArray();
            if (this.getIgnoreWhiteSpaceTextContent() && DOMDocumentSerializer.isWhiteSpace(cArray, 0, n)) {
                return;
            }
            this.encodeTermination();
            this.encodeCharactersNoClone(cArray, 0, n);
        }
    }

    protected final void serializeCDATA(Node node) throws IOException {
        int n;
        String string = node.getNodeValue();
        int n2 = n = string != null ? string.length() : 0;
        if (n == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        if (this.getIgnoreWhiteSpaceTextContent() && DOMDocumentSerializer.isWhiteSpace(cArray, 0, n)) {
            return;
        }
        this.encodeTermination();
        try {
            this.encodeCIIBuiltInAlgorithmDataAsCDATA(cArray, 0, n);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new IOException("");
        }
    }

    protected final void serializeComment(Node node) throws IOException {
        int n;
        if (this.getIgnoreComments()) {
            return;
        }
        this.encodeTermination();
        String string = node.getNodeValue();
        int n2 = n = string != null ? string.length() : 0;
        if (n == 0) {
            this.encodeComment(this._charBuffer, 0, 0);
        } else if (n < this._charBuffer.length) {
            string.getChars(0, n, this._charBuffer, 0);
            this.encodeComment(this._charBuffer, 0, n);
        } else {
            char[] cArray = string.toCharArray();
            this.encodeCommentNoClone(cArray, 0, n);
        }
    }

    protected final void serializeProcessingInstruction(Node node) throws IOException {
        if (this.getIgnoreProcesingInstructions()) {
            return;
        }
        this.encodeTermination();
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        this.encodeProcessingInstruction(string, string2);
    }

    protected final void encodeElement(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(string2);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (string != qualifiedNameArray[i].namespaceName && !string.equals(qualifiedNameArray[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(qualifiedNameArray[i].index);
                return;
            }
        }
        if (string3 != null) {
            this.encodeLiteralElementQualifiedNameOnThirdBit(string, DOMDocumentSerializer.getPrefixFromQualifiedName(string2), string3, entry);
        } else {
            this.encodeLiteralElementQualifiedNameOnThirdBit(string, "", string2, entry);
        }
    }

    protected final void encodeAttribute(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(string2);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (string != qualifiedNameArray[i].namespaceName && !string.equals(qualifiedNameArray[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(qualifiedNameArray[i].index);
                return;
            }
        }
        if (string3 != null) {
            this.encodeLiteralAttributeQualifiedNameOnSecondBit(string, DOMDocumentSerializer.getPrefixFromQualifiedName(string2), string3, entry);
        } else {
            this.encodeLiteralAttributeQualifiedNameOnSecondBit(string, "", string2, entry);
        }
    }
}

