/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.https.DefaultHostnameVerifier;
import sun.security.action.GetPropertyAction;
import sun.security.util.HostnameChecker;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int httpsPortNumber = 443;
    private HostnameVerifier hv;
    private SSLSocketFactory sslSocketFactory;
    private SSLSession session;

    protected int getDefaultPort() {
        return 443;
    }

    private String[] getCipherSuites() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private String[] getProtocols() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private String getUserAgent() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.agent"));
        if (string == null || string.length() == 0) {
            string = "JSSE";
        }
        return string;
    }

    private static Proxy newHttpProxy(String string, int n) {
        InetSocketAddress inetSocketAddress = null;
        final String string2 = string;
        final int n2 = n < 0 ? 443 : n;
        try {
            inetSocketAddress = (InetSocketAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new InetSocketAddress(string2, n2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
    }

    private HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL) throws IOException {
        this(sSLSocketFactory, uRL, (String)null, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n) throws IOException {
        this(sSLSocketFactory, uRL, string, n, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n, int n2) throws IOException {
        this(sSLSocketFactory, uRL, string == null ? null : HttpsClient.newHttpProxy(string, n), n2);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, Proxy proxy, int n) throws IOException {
        this.proxy = proxy;
        this.setSSLSocketFactory(sSLSocketFactory);
        this.proxyDisabled = true;
        this.host = uRL.getHost();
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(n);
        this.cookieHandler = (CookieHandler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CookieHandler.getDefault();
            }
        });
        this.openServer();
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, true);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, boolean bl) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, (String)null, -1, bl);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string, n, true);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string, n, bl, -1);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl, int n2) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string == null ? null : HttpsClient.newHttpProxy(string, n), bl, n2);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, Proxy proxy, boolean bl, int n) throws IOException {
        HttpsClient httpsClient = null;
        if (bl && (httpsClient = (HttpsClient)kac.get(uRL, sSLSocketFactory)) != null) {
            httpsClient.cachedHttpClient = true;
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sSLSocketFactory, uRL, proxy, n);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpsClient.url = uRL;
        }
        httpsClient.setHostnameVerifier(hostnameVerifier);
        return httpsClient;
    }

    void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hv = hostnameVerifier;
    }

    void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    protected Socket createSocket() throws IOException {
        try {
            return this.sslSocketFactory.createSocket();
        }
        catch (SocketException socketException) {
            Throwable throwable = socketException.getCause();
            if (throwable != null && throwable instanceof UnsupportedOperationException) {
                return super.createSocket();
            }
            throw socketException;
        }
    }

    public boolean needsTunneling() {
        return this.proxy != null && this.proxy.type() != Proxy.Type.DIRECT && this.proxy.type() != Proxy.Type.SOCKS;
    }

    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket sSLSocket = null;
            SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
            try {
                if (!(this.serverSocket instanceof SSLSocket)) {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.serverSocket, this.host, this.port, true);
                } else {
                    sSLSocket = (SSLSocket)this.serverSocket;
                    if (sSLSocket instanceof SSLSocketImpl) {
                        ((SSLSocketImpl)sSLSocket).setHost(this.host);
                    }
                }
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
            String[] stringArray = this.getProtocols();
            String[] stringArray2 = this.getCipherSuites();
            if (stringArray != null) {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            if (stringArray2 != null) {
                sSLSocket.setEnabledCipherSuites(stringArray2);
            }
            sSLSocket.addHandshakeCompletedListener(this);
            boolean bl = false;
            if (this.hv instanceof DefaultHostnameVerifier && sSLSocket instanceof SSLSocketImpl && ((SSLSocketImpl)sSLSocket).trySetHostnameVerification("HTTPS")) {
                bl = true;
            }
            sSLSocket.startHandshake();
            this.session = sSLSocket.getSession();
            this.serverSocket = sSLSocket;
            try {
                this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(encoding + " encoding not found");
            }
            if (!bl) {
                this.checkURLSpoofing(this.hv);
            }
        } else {
            this.session = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    private void checkURLSpoofing(HostnameVerifier hostnameVerifier) throws IOException {
        boolean bl = false;
        String string = this.url.getHost();
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        Certificate[] certificateArray = null;
        try {
            HostnameChecker hostnameChecker = HostnameChecker.getInstance((byte)1);
            Principal principal = this.getPeerPrincipal();
            if (principal instanceof KerberosPrincipal) {
                if (!HostnameChecker.match((String)string, (KerberosPrincipal)((KerberosPrincipal)principal))) {
                    throw new SSLPeerUnverifiedException("Hostname checker failed for Kerberos");
                }
            } else {
                certificateArray = this.session.getPeerCertificates();
                if (!(certificateArray[0] instanceof java.security.cert.X509Certificate)) {
                    throw new SSLPeerUnverifiedException("");
                }
                java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateArray[0];
                hostnameChecker.match(string, x509Certificate);
            }
            return;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        String string2 = this.session.getCipherSuite();
        if (string2 != null && string2.indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(string, this.session)) {
            return;
        }
        this.serverSocket.close();
        this.session.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    protected void putInKeepAliveCache() {
        kac.put(this.url, this.sslSocketFactory, this);
    }

    public void closeIdleConnection() {
        HttpClient httpClient = (HttpClient)kac.get(this.url, this.sslSocketFactory);
        if (httpClient != null) {
            httpClient.closeServer();
        }
    }

    String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getLocalCertificates();
    }

    Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = this.session.getPeerPrincipal();
        }
        catch (AbstractMethodError abstractMethodError) {
            Certificate[] certificateArray = this.session.getPeerCertificates();
            principal = ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }
        return principal;
    }

    Principal getLocalPrincipal() {
        Principal principal;
        block2: {
            try {
                principal = this.session.getLocalPrincipal();
            }
            catch (AbstractMethodError abstractMethodError) {
                principal = null;
                Certificate[] certificateArray = this.session.getLocalCertificates();
                if (certificateArray == null) break block2;
                principal = ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
            }
        }
        return principal;
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.session = handshakeCompletedEvent.getSession();
    }

    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return super.getProxyHostUsed();
    }

    public int getProxyPortUsed() {
        return this.proxy == null || this.proxy.type() == Proxy.Type.DIRECT || this.proxy.type() == Proxy.Type.SOCKS ? -1 : ((InetSocketAddress)this.proxy.address()).getPort();
    }
}

